package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.backupgateway.model.primitives.{ResourceArn, Path, Time, Name}
import scala.jdk.CollectionConverters._
final case class VirtualMachine(
    hostName: Option[Name] = None,
    hypervisorId: Option[String] = None,
    lastBackupDate: Option[Time] = None,
    name: Option[Name] = None,
    path: Option[Path] = None,
    resourceArn: Option[ResourceArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.VirtualMachine = {
    import VirtualMachine.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.VirtualMachine
      .builder()
      .optionallyWith(
        hostName.map(value => Name.unwrap(value): java.lang.String)
      )(_.hostName)
      .optionallyWith(hypervisorId.map(value => value: java.lang.String))(
        _.hypervisorId
      )
      .optionallyWith(lastBackupDate.map(value => Time.unwrap(value): Instant))(
        _.lastBackupDate
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(path.map(value => Path.unwrap(value): java.lang.String))(
        _.path
      )
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.VirtualMachine.ReadOnly =
    zio.aws.backupgateway.model.VirtualMachine.wrap(buildAwsValue())
}
object VirtualMachine {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.VirtualMachine
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.VirtualMachine =
      zio.aws.backupgateway.model.VirtualMachine(
        hostName.map(value => value),
        hypervisorId.map(value => value),
        lastBackupDate.map(value => value),
        name.map(value => value),
        path.map(value => value),
        resourceArn.map(value => value)
      )
    def hostName: Option[Name]
    def hypervisorId: Option[String]
    def lastBackupDate: Option[Time]
    def name: Option[Name]
    def path: Option[Path]
    def resourceArn: Option[ResourceArn]
    def getHostName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("hostName", hostName)
    def getHypervisorId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hypervisorId", hypervisorId)
    def getLastBackupDate: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("lastBackupDate", lastBackupDate)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getPath: ZIO[Any, AwsError, Path] =
      AwsError.unwrapOptionField("path", path)
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.VirtualMachine
  ) extends zio.aws.backupgateway.model.VirtualMachine.ReadOnly {
    override val hostName: Option[Name] = scala
      .Option(impl.hostName())
      .map(value => zio.aws.backupgateway.model.primitives.Name(value))
    override val hypervisorId: Option[String] =
      scala.Option(impl.hypervisorId()).map(value => value: String)
    override val lastBackupDate: Option[Time] = scala
      .Option(impl.lastBackupDate())
      .map(value => zio.aws.backupgateway.model.primitives.Time(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.backupgateway.model.primitives.Name(value))
    override val path: Option[Path] = scala
      .Option(impl.path())
      .map(value => zio.aws.backupgateway.model.primitives.Path(value))
    override val resourceArn: Option[ResourceArn] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.backupgateway.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.VirtualMachine
  ): zio.aws.backupgateway.model.VirtualMachine.ReadOnly = new Wrapper(impl)
}
