package zio.aws.backupgateway
import zio.aws.backupgateway.model.TestHypervisorConfigurationResponse.ReadOnly
import software.amazon.awssdk.services.backupgateway.{
  BackupGatewayAsyncClientBuilder,
  BackupGatewayAsyncClient
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.backupgateway.model.{
  DeleteGatewayRequest,
  PutHypervisorPropertyMappingsResponse,
  DeleteHypervisorResponse,
  PutMaintenanceStartTimeResponse,
  DeleteGatewayResponse,
  Gateway,
  ListVirtualMachinesRequest,
  DisassociateGatewayFromServerRequest,
  PutHypervisorPropertyMappingsRequest,
  GetBandwidthRateLimitScheduleResponse,
  PutBandwidthRateLimitScheduleRequest,
  PutBandwidthRateLimitScheduleResponse,
  GetGatewayResponse,
  UpdateGatewaySoftwareNowRequest,
  ListGatewaysResponse,
  ListTagsForResourceRequest,
  Hypervisor,
  GetHypervisorRequest,
  ImportHypervisorConfigurationRequest,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  ListHypervisorsResponse,
  GetHypervisorPropertyMappingsRequest,
  GetVirtualMachineRequest,
  UpdateGatewayInformationResponse,
  GetVirtualMachineResponse,
  GetGatewayRequest,
  PutMaintenanceStartTimeRequest,
  UntagResourceRequest,
  DisassociateGatewayFromServerResponse,
  AssociateGatewayToServerRequest,
  UpdateHypervisorResponse,
  StartVirtualMachinesMetadataSyncResponse,
  VirtualMachine,
  StartVirtualMachinesMetadataSyncRequest,
  GetHypervisorPropertyMappingsResponse,
  CreateGatewayRequest,
  UpdateGatewaySoftwareNowResponse,
  ListHypervisorsRequest,
  DeleteHypervisorRequest,
  GetHypervisorResponse,
  ListVirtualMachinesResponse,
  TestHypervisorConfigurationRequest,
  UpdateHypervisorRequest,
  TestHypervisorConfigurationResponse,
  ListGatewaysRequest,
  TagResourceResponse,
  CreateGatewayResponse,
  ImportHypervisorConfigurationResponse,
  AssociateGatewayToServerResponse,
  GetBandwidthRateLimitScheduleRequest,
  TagResourceRequest,
  UpdateGatewayInformationRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait BackupGateway extends AspectSupport[BackupGateway] {
  val api: BackupGatewayAsyncClient
  def disassociateGatewayFromServer(
      request: zio.aws.backupgateway.model.DisassociateGatewayFromServerRequest
  ): IO[
    AwsError,
    zio.aws.backupgateway.model.DisassociateGatewayFromServerResponse.ReadOnly
  ]
  def listHypervisors(
      request: zio.aws.backupgateway.model.ListHypervisorsRequest
  ): ZStream[Any, AwsError, zio.aws.backupgateway.model.Hypervisor.ReadOnly]
  def listHypervisorsPaginated(
      request: zio.aws.backupgateway.model.ListHypervisorsRequest
  ): IO[AwsError, zio.aws.backupgateway.model.ListHypervisorsResponse.ReadOnly]
  def importHypervisorConfiguration(
      request: zio.aws.backupgateway.model.ImportHypervisorConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.backupgateway.model.ImportHypervisorConfigurationResponse.ReadOnly
  ]
  def createGateway(
      request: zio.aws.backupgateway.model.CreateGatewayRequest
  ): IO[AwsError, zio.aws.backupgateway.model.CreateGatewayResponse.ReadOnly]
  def updateGatewayInformation(
      request: zio.aws.backupgateway.model.UpdateGatewayInformationRequest
  ): IO[
    AwsError,
    zio.aws.backupgateway.model.UpdateGatewayInformationResponse.ReadOnly
  ]
  def deleteGateway(
      request: zio.aws.backupgateway.model.DeleteGatewayRequest
  ): IO[AwsError, zio.aws.backupgateway.model.DeleteGatewayResponse.ReadOnly]
  def updateHypervisor(
      request: zio.aws.backupgateway.model.UpdateHypervisorRequest
  ): IO[AwsError, zio.aws.backupgateway.model.UpdateHypervisorResponse.ReadOnly]
  def getHypervisorPropertyMappings(
      request: zio.aws.backupgateway.model.GetHypervisorPropertyMappingsRequest
  ): IO[
    AwsError,
    zio.aws.backupgateway.model.GetHypervisorPropertyMappingsResponse.ReadOnly
  ]
  def getHypervisor(
      request: zio.aws.backupgateway.model.GetHypervisorRequest
  ): IO[AwsError, zio.aws.backupgateway.model.GetHypervisorResponse.ReadOnly]
  def testHypervisorConfiguration(
      request: zio.aws.backupgateway.model.TestHypervisorConfigurationRequest
  ): IO[AwsError, ReadOnly]
  def getBandwidthRateLimitSchedule(
      request: zio.aws.backupgateway.model.GetBandwidthRateLimitScheduleRequest
  ): IO[
    AwsError,
    zio.aws.backupgateway.model.GetBandwidthRateLimitScheduleResponse.ReadOnly
  ]
  def putBandwidthRateLimitSchedule(
      request: zio.aws.backupgateway.model.PutBandwidthRateLimitScheduleRequest
  ): IO[
    AwsError,
    zio.aws.backupgateway.model.PutBandwidthRateLimitScheduleResponse.ReadOnly
  ]
  def deleteHypervisor(
      request: zio.aws.backupgateway.model.DeleteHypervisorRequest
  ): IO[AwsError, zio.aws.backupgateway.model.DeleteHypervisorResponse.ReadOnly]
  def putHypervisorPropertyMappings(
      request: zio.aws.backupgateway.model.PutHypervisorPropertyMappingsRequest
  ): IO[
    AwsError,
    zio.aws.backupgateway.model.PutHypervisorPropertyMappingsResponse.ReadOnly
  ]
  def getVirtualMachine(
      request: zio.aws.backupgateway.model.GetVirtualMachineRequest
  ): IO[
    AwsError,
    zio.aws.backupgateway.model.GetVirtualMachineResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.backupgateway.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.backupgateway.model.UntagResourceResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.backupgateway.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.backupgateway.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.backupgateway.model.TagResourceRequest
  ): IO[AwsError, zio.aws.backupgateway.model.TagResourceResponse.ReadOnly]
  def updateGatewaySoftwareNow(
      request: zio.aws.backupgateway.model.UpdateGatewaySoftwareNowRequest
  ): IO[
    AwsError,
    zio.aws.backupgateway.model.UpdateGatewaySoftwareNowResponse.ReadOnly
  ]
  def putMaintenanceStartTime(
      request: zio.aws.backupgateway.model.PutMaintenanceStartTimeRequest
  ): IO[
    AwsError,
    zio.aws.backupgateway.model.PutMaintenanceStartTimeResponse.ReadOnly
  ]
  def startVirtualMachinesMetadataSync(
      request: zio.aws.backupgateway.model.StartVirtualMachinesMetadataSyncRequest
  ): IO[
    AwsError,
    zio.aws.backupgateway.model.StartVirtualMachinesMetadataSyncResponse.ReadOnly
  ]
  def getGateway(
      request: zio.aws.backupgateway.model.GetGatewayRequest
  ): IO[AwsError, zio.aws.backupgateway.model.GetGatewayResponse.ReadOnly]
  def associateGatewayToServer(
      request: zio.aws.backupgateway.model.AssociateGatewayToServerRequest
  ): IO[
    AwsError,
    zio.aws.backupgateway.model.AssociateGatewayToServerResponse.ReadOnly
  ]
  def listGateways(
      request: zio.aws.backupgateway.model.ListGatewaysRequest
  ): ZStream[Any, AwsError, zio.aws.backupgateway.model.Gateway.ReadOnly]
  def listGatewaysPaginated(
      request: zio.aws.backupgateway.model.ListGatewaysRequest
  ): IO[AwsError, zio.aws.backupgateway.model.ListGatewaysResponse.ReadOnly]
  def listVirtualMachines(
      request: zio.aws.backupgateway.model.ListVirtualMachinesRequest
  ): ZStream[Any, AwsError, zio.aws.backupgateway.model.VirtualMachine.ReadOnly]
  def listVirtualMachinesPaginated(
      request: zio.aws.backupgateway.model.ListVirtualMachinesRequest
  ): IO[
    AwsError,
    zio.aws.backupgateway.model.ListVirtualMachinesResponse.ReadOnly
  ]
}
object BackupGateway {
  val live: ZLayer[AwsConfig, java.lang.Throwable, BackupGateway] = customized(
    identity
  )
  def customized(
      customization: BackupGatewayAsyncClientBuilder => BackupGatewayAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, BackupGateway] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: BackupGatewayAsyncClientBuilder => BackupGatewayAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, BackupGateway] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = BackupGatewayAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[BackupGatewayAsyncClient, BackupGatewayAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      BackupGatewayAsyncClient,
      BackupGatewayAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new BackupGatewayImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class BackupGatewayImpl[R](
      override val api: BackupGatewayAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends BackupGateway
      with AwsServiceBase[R] {
    override val serviceName: String = "BackupGateway"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): BackupGatewayImpl[R1] = new BackupGatewayImpl(api, newAspect, r)
    def disassociateGatewayFromServer(
        request: zio.aws.backupgateway.model.DisassociateGatewayFromServerRequest
    ): IO[
      AwsError,
      zio.aws.backupgateway.model.DisassociateGatewayFromServerResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateGatewayFromServerRequest,
      DisassociateGatewayFromServerResponse
    ]("disassociateGatewayFromServer", api.disassociateGatewayFromServer)(
      request.buildAwsValue()
    ).map(
      zio.aws.backupgateway.model.DisassociateGatewayFromServerResponse.wrap
    ).provideEnvironment(r)
    def listHypervisors(
        request: zio.aws.backupgateway.model.ListHypervisorsRequest
    ): ZStream[Any, AwsError, zio.aws.backupgateway.model.Hypervisor.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListHypervisorsRequest,
        ListHypervisorsResponse,
        Hypervisor
      ](
        "listHypervisors",
        api.listHypervisors,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.hypervisors().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.backupgateway.model.Hypervisor.wrap(item))
        .provideEnvironment(r)
    def listHypervisorsPaginated(
        request: zio.aws.backupgateway.model.ListHypervisorsRequest
    ): IO[
      AwsError,
      zio.aws.backupgateway.model.ListHypervisorsResponse.ReadOnly
    ] = asyncRequestResponse[ListHypervisorsRequest, ListHypervisorsResponse](
      "listHypervisors",
      api.listHypervisors
    )(request.buildAwsValue())
      .map(zio.aws.backupgateway.model.ListHypervisorsResponse.wrap)
      .provideEnvironment(r)
    def importHypervisorConfiguration(
        request: zio.aws.backupgateway.model.ImportHypervisorConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.backupgateway.model.ImportHypervisorConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      ImportHypervisorConfigurationRequest,
      ImportHypervisorConfigurationResponse
    ]("importHypervisorConfiguration", api.importHypervisorConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.backupgateway.model.ImportHypervisorConfigurationResponse.wrap
    ).provideEnvironment(r)
    def createGateway(
        request: zio.aws.backupgateway.model.CreateGatewayRequest
    ): IO[
      AwsError,
      zio.aws.backupgateway.model.CreateGatewayResponse.ReadOnly
    ] = asyncRequestResponse[CreateGatewayRequest, CreateGatewayResponse](
      "createGateway",
      api.createGateway
    )(request.buildAwsValue())
      .map(zio.aws.backupgateway.model.CreateGatewayResponse.wrap)
      .provideEnvironment(r)
    def updateGatewayInformation(
        request: zio.aws.backupgateway.model.UpdateGatewayInformationRequest
    ): IO[
      AwsError,
      zio.aws.backupgateway.model.UpdateGatewayInformationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateGatewayInformationRequest,
      UpdateGatewayInformationResponse
    ]("updateGatewayInformation", api.updateGatewayInformation)(
      request.buildAwsValue()
    ).map(zio.aws.backupgateway.model.UpdateGatewayInformationResponse.wrap)
      .provideEnvironment(r)
    def deleteGateway(
        request: zio.aws.backupgateway.model.DeleteGatewayRequest
    ): IO[
      AwsError,
      zio.aws.backupgateway.model.DeleteGatewayResponse.ReadOnly
    ] = asyncRequestResponse[DeleteGatewayRequest, DeleteGatewayResponse](
      "deleteGateway",
      api.deleteGateway
    )(request.buildAwsValue())
      .map(zio.aws.backupgateway.model.DeleteGatewayResponse.wrap)
      .provideEnvironment(r)
    def updateHypervisor(
        request: zio.aws.backupgateway.model.UpdateHypervisorRequest
    ): IO[
      AwsError,
      zio.aws.backupgateway.model.UpdateHypervisorResponse.ReadOnly
    ] = asyncRequestResponse[UpdateHypervisorRequest, UpdateHypervisorResponse](
      "updateHypervisor",
      api.updateHypervisor
    )(request.buildAwsValue())
      .map(zio.aws.backupgateway.model.UpdateHypervisorResponse.wrap)
      .provideEnvironment(r)
    def getHypervisorPropertyMappings(
        request: zio.aws.backupgateway.model.GetHypervisorPropertyMappingsRequest
    ): IO[
      AwsError,
      zio.aws.backupgateway.model.GetHypervisorPropertyMappingsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetHypervisorPropertyMappingsRequest,
      GetHypervisorPropertyMappingsResponse
    ]("getHypervisorPropertyMappings", api.getHypervisorPropertyMappings)(
      request.buildAwsValue()
    ).map(
      zio.aws.backupgateway.model.GetHypervisorPropertyMappingsResponse.wrap
    ).provideEnvironment(r)
    def getHypervisor(
        request: zio.aws.backupgateway.model.GetHypervisorRequest
    ): IO[
      AwsError,
      zio.aws.backupgateway.model.GetHypervisorResponse.ReadOnly
    ] = asyncRequestResponse[GetHypervisorRequest, GetHypervisorResponse](
      "getHypervisor",
      api.getHypervisor
    )(request.buildAwsValue())
      .map(zio.aws.backupgateway.model.GetHypervisorResponse.wrap)
      .provideEnvironment(r)
    def testHypervisorConfiguration(
        request: zio.aws.backupgateway.model.TestHypervisorConfigurationRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      TestHypervisorConfigurationRequest,
      TestHypervisorConfigurationResponse
    ]("testHypervisorConfiguration", api.testHypervisorConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.backupgateway.model.TestHypervisorConfigurationResponse.wrap)
      .provideEnvironment(r)
    def getBandwidthRateLimitSchedule(
        request: zio.aws.backupgateway.model.GetBandwidthRateLimitScheduleRequest
    ): IO[
      AwsError,
      zio.aws.backupgateway.model.GetBandwidthRateLimitScheduleResponse.ReadOnly
    ] = asyncRequestResponse[
      GetBandwidthRateLimitScheduleRequest,
      GetBandwidthRateLimitScheduleResponse
    ]("getBandwidthRateLimitSchedule", api.getBandwidthRateLimitSchedule)(
      request.buildAwsValue()
    ).map(
      zio.aws.backupgateway.model.GetBandwidthRateLimitScheduleResponse.wrap
    ).provideEnvironment(r)
    def putBandwidthRateLimitSchedule(
        request: zio.aws.backupgateway.model.PutBandwidthRateLimitScheduleRequest
    ): IO[
      AwsError,
      zio.aws.backupgateway.model.PutBandwidthRateLimitScheduleResponse.ReadOnly
    ] = asyncRequestResponse[
      PutBandwidthRateLimitScheduleRequest,
      PutBandwidthRateLimitScheduleResponse
    ]("putBandwidthRateLimitSchedule", api.putBandwidthRateLimitSchedule)(
      request.buildAwsValue()
    ).map(
      zio.aws.backupgateway.model.PutBandwidthRateLimitScheduleResponse.wrap
    ).provideEnvironment(r)
    def deleteHypervisor(
        request: zio.aws.backupgateway.model.DeleteHypervisorRequest
    ): IO[
      AwsError,
      zio.aws.backupgateway.model.DeleteHypervisorResponse.ReadOnly
    ] = asyncRequestResponse[DeleteHypervisorRequest, DeleteHypervisorResponse](
      "deleteHypervisor",
      api.deleteHypervisor
    )(request.buildAwsValue())
      .map(zio.aws.backupgateway.model.DeleteHypervisorResponse.wrap)
      .provideEnvironment(r)
    def putHypervisorPropertyMappings(
        request: zio.aws.backupgateway.model.PutHypervisorPropertyMappingsRequest
    ): IO[
      AwsError,
      zio.aws.backupgateway.model.PutHypervisorPropertyMappingsResponse.ReadOnly
    ] = asyncRequestResponse[
      PutHypervisorPropertyMappingsRequest,
      PutHypervisorPropertyMappingsResponse
    ]("putHypervisorPropertyMappings", api.putHypervisorPropertyMappings)(
      request.buildAwsValue()
    ).map(
      zio.aws.backupgateway.model.PutHypervisorPropertyMappingsResponse.wrap
    ).provideEnvironment(r)
    def getVirtualMachine(
        request: zio.aws.backupgateway.model.GetVirtualMachineRequest
    ): IO[
      AwsError,
      zio.aws.backupgateway.model.GetVirtualMachineResponse.ReadOnly
    ] =
      asyncRequestResponse[GetVirtualMachineRequest, GetVirtualMachineResponse](
        "getVirtualMachine",
        api.getVirtualMachine
      )(request.buildAwsValue())
        .map(zio.aws.backupgateway.model.GetVirtualMachineResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.backupgateway.model.UntagResourceRequest
    ): IO[
      AwsError,
      zio.aws.backupgateway.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
      "untagResource",
      api.untagResource
    )(request.buildAwsValue())
      .map(zio.aws.backupgateway.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.backupgateway.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.backupgateway.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.backupgateway.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.backupgateway.model.TagResourceRequest
    ): IO[AwsError, zio.aws.backupgateway.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.backupgateway.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def updateGatewaySoftwareNow(
        request: zio.aws.backupgateway.model.UpdateGatewaySoftwareNowRequest
    ): IO[
      AwsError,
      zio.aws.backupgateway.model.UpdateGatewaySoftwareNowResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateGatewaySoftwareNowRequest,
      UpdateGatewaySoftwareNowResponse
    ]("updateGatewaySoftwareNow", api.updateGatewaySoftwareNow)(
      request.buildAwsValue()
    ).map(zio.aws.backupgateway.model.UpdateGatewaySoftwareNowResponse.wrap)
      .provideEnvironment(r)
    def putMaintenanceStartTime(
        request: zio.aws.backupgateway.model.PutMaintenanceStartTimeRequest
    ): IO[
      AwsError,
      zio.aws.backupgateway.model.PutMaintenanceStartTimeResponse.ReadOnly
    ] = asyncRequestResponse[
      PutMaintenanceStartTimeRequest,
      PutMaintenanceStartTimeResponse
    ]("putMaintenanceStartTime", api.putMaintenanceStartTime)(
      request.buildAwsValue()
    ).map(zio.aws.backupgateway.model.PutMaintenanceStartTimeResponse.wrap)
      .provideEnvironment(r)
    def startVirtualMachinesMetadataSync(
        request: zio.aws.backupgateway.model.StartVirtualMachinesMetadataSyncRequest
    ): IO[
      AwsError,
      zio.aws.backupgateway.model.StartVirtualMachinesMetadataSyncResponse.ReadOnly
    ] = asyncRequestResponse[
      StartVirtualMachinesMetadataSyncRequest,
      StartVirtualMachinesMetadataSyncResponse
    ]("startVirtualMachinesMetadataSync", api.startVirtualMachinesMetadataSync)(
      request.buildAwsValue()
    ).map(
      zio.aws.backupgateway.model.StartVirtualMachinesMetadataSyncResponse.wrap
    ).provideEnvironment(r)
    def getGateway(
        request: zio.aws.backupgateway.model.GetGatewayRequest
    ): IO[AwsError, zio.aws.backupgateway.model.GetGatewayResponse.ReadOnly] =
      asyncRequestResponse[GetGatewayRequest, GetGatewayResponse](
        "getGateway",
        api.getGateway
      )(request.buildAwsValue())
        .map(zio.aws.backupgateway.model.GetGatewayResponse.wrap)
        .provideEnvironment(r)
    def associateGatewayToServer(
        request: zio.aws.backupgateway.model.AssociateGatewayToServerRequest
    ): IO[
      AwsError,
      zio.aws.backupgateway.model.AssociateGatewayToServerResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateGatewayToServerRequest,
      AssociateGatewayToServerResponse
    ]("associateGatewayToServer", api.associateGatewayToServer)(
      request.buildAwsValue()
    ).map(zio.aws.backupgateway.model.AssociateGatewayToServerResponse.wrap)
      .provideEnvironment(r)
    def listGateways(
        request: zio.aws.backupgateway.model.ListGatewaysRequest
    ): ZStream[Any, AwsError, zio.aws.backupgateway.model.Gateway.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListGatewaysRequest,
        ListGatewaysResponse,
        Gateway
      ](
        "listGateways",
        api.listGateways,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.gateways().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.backupgateway.model.Gateway.wrap(item))
        .provideEnvironment(r)
    def listGatewaysPaginated(
        request: zio.aws.backupgateway.model.ListGatewaysRequest
    ): IO[AwsError, zio.aws.backupgateway.model.ListGatewaysResponse.ReadOnly] =
      asyncRequestResponse[ListGatewaysRequest, ListGatewaysResponse](
        "listGateways",
        api.listGateways
      )(request.buildAwsValue())
        .map(zio.aws.backupgateway.model.ListGatewaysResponse.wrap)
        .provideEnvironment(r)
    def listVirtualMachines(
        request: zio.aws.backupgateway.model.ListVirtualMachinesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.backupgateway.model.VirtualMachine.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListVirtualMachinesRequest,
      ListVirtualMachinesResponse,
      VirtualMachine
    ](
      "listVirtualMachines",
      api.listVirtualMachines,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.virtualMachines().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.backupgateway.model.VirtualMachine.wrap(item))
      .provideEnvironment(r)
    def listVirtualMachinesPaginated(
        request: zio.aws.backupgateway.model.ListVirtualMachinesRequest
    ): IO[
      AwsError,
      zio.aws.backupgateway.model.ListVirtualMachinesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListVirtualMachinesRequest,
      ListVirtualMachinesResponse
    ]("listVirtualMachines", api.listVirtualMachines)(request.buildAwsValue())
      .map(zio.aws.backupgateway.model.ListVirtualMachinesResponse.wrap)
      .provideEnvironment(r)
  }
  def disassociateGatewayFromServer(
      request: zio.aws.backupgateway.model.DisassociateGatewayFromServerRequest
  ): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.DisassociateGatewayFromServerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateGatewayFromServer(request))
  def listHypervisors(
      request: zio.aws.backupgateway.model.ListHypervisorsRequest
  ): ZStream[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.Hypervisor.ReadOnly
  ] = ZStream.serviceWithStream(_.listHypervisors(request))
  def listHypervisorsPaginated(
      request: zio.aws.backupgateway.model.ListHypervisorsRequest
  ): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.ListHypervisorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listHypervisorsPaginated(request))
  def importHypervisorConfiguration(
      request: zio.aws.backupgateway.model.ImportHypervisorConfigurationRequest
  ): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.ImportHypervisorConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importHypervisorConfiguration(request))
  def createGateway(
      request: zio.aws.backupgateway.model.CreateGatewayRequest
  ): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.CreateGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGateway(request))
  def updateGatewayInformation(
      request: zio.aws.backupgateway.model.UpdateGatewayInformationRequest
  ): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.UpdateGatewayInformationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGatewayInformation(request))
  def deleteGateway(
      request: zio.aws.backupgateway.model.DeleteGatewayRequest
  ): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.DeleteGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteGateway(request))
  def updateHypervisor(
      request: zio.aws.backupgateway.model.UpdateHypervisorRequest
  ): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.UpdateHypervisorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateHypervisor(request))
  def getHypervisorPropertyMappings(
      request: zio.aws.backupgateway.model.GetHypervisorPropertyMappingsRequest
  ): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.GetHypervisorPropertyMappingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getHypervisorPropertyMappings(request))
  def getHypervisor(
      request: zio.aws.backupgateway.model.GetHypervisorRequest
  ): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.GetHypervisorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getHypervisor(request))
  def testHypervisorConfiguration(
      request: zio.aws.backupgateway.model.TestHypervisorConfigurationRequest
  ): ZIO[zio.aws.backupgateway.BackupGateway, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.testHypervisorConfiguration(request))
  def getBandwidthRateLimitSchedule(
      request: zio.aws.backupgateway.model.GetBandwidthRateLimitScheduleRequest
  ): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.GetBandwidthRateLimitScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBandwidthRateLimitSchedule(request))
  def putBandwidthRateLimitSchedule(
      request: zio.aws.backupgateway.model.PutBandwidthRateLimitScheduleRequest
  ): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.PutBandwidthRateLimitScheduleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putBandwidthRateLimitSchedule(request))
  def deleteHypervisor(
      request: zio.aws.backupgateway.model.DeleteHypervisorRequest
  ): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.DeleteHypervisorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteHypervisor(request))
  def putHypervisorPropertyMappings(
      request: zio.aws.backupgateway.model.PutHypervisorPropertyMappingsRequest
  ): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.PutHypervisorPropertyMappingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putHypervisorPropertyMappings(request))
  def getVirtualMachine(
      request: zio.aws.backupgateway.model.GetVirtualMachineRequest
  ): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.GetVirtualMachineResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVirtualMachine(request))
  def untagResource(
      request: zio.aws.backupgateway.model.UntagResourceRequest
  ): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listTagsForResource(
      request: zio.aws.backupgateway.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: zio.aws.backupgateway.model.TagResourceRequest): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def updateGatewaySoftwareNow(
      request: zio.aws.backupgateway.model.UpdateGatewaySoftwareNowRequest
  ): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.UpdateGatewaySoftwareNowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGatewaySoftwareNow(request))
  def putMaintenanceStartTime(
      request: zio.aws.backupgateway.model.PutMaintenanceStartTimeRequest
  ): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.PutMaintenanceStartTimeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putMaintenanceStartTime(request))
  def startVirtualMachinesMetadataSync(
      request: zio.aws.backupgateway.model.StartVirtualMachinesMetadataSyncRequest
  ): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.StartVirtualMachinesMetadataSyncResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startVirtualMachinesMetadataSync(request))
  def getGateway(request: zio.aws.backupgateway.model.GetGatewayRequest): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.GetGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGateway(request))
  def associateGatewayToServer(
      request: zio.aws.backupgateway.model.AssociateGatewayToServerRequest
  ): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.AssociateGatewayToServerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateGatewayToServer(request))
  def listGateways(
      request: zio.aws.backupgateway.model.ListGatewaysRequest
  ): ZStream[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.Gateway.ReadOnly
  ] = ZStream.serviceWithStream(_.listGateways(request))
  def listGatewaysPaginated(
      request: zio.aws.backupgateway.model.ListGatewaysRequest
  ): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.ListGatewaysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGatewaysPaginated(request))
  def listVirtualMachines(
      request: zio.aws.backupgateway.model.ListVirtualMachinesRequest
  ): ZStream[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.VirtualMachine.ReadOnly
  ] = ZStream.serviceWithStream(_.listVirtualMachines(request))
  def listVirtualMachinesPaginated(
      request: zio.aws.backupgateway.model.ListVirtualMachinesRequest
  ): ZIO[
    zio.aws.backupgateway.BackupGateway,
    AwsError,
    zio.aws.backupgateway.model.ListVirtualMachinesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVirtualMachinesPaginated(request))
}
