package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetVirtualMachineResponse(
    virtualMachine: Optional[
      zio.aws.backupgateway.model.VirtualMachineDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.GetVirtualMachineResponse = {
    import GetVirtualMachineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.GetVirtualMachineResponse
      .builder()
      .optionallyWith(virtualMachine.map(value => value.buildAwsValue()))(
        _.virtualMachine
      )
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.GetVirtualMachineResponse.ReadOnly =
    zio.aws.backupgateway.model.GetVirtualMachineResponse.wrap(buildAwsValue())
}
object GetVirtualMachineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.GetVirtualMachineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.GetVirtualMachineResponse =
      zio.aws.backupgateway.model.GetVirtualMachineResponse(
        virtualMachine.map(value => value.asEditable)
      )
    def virtualMachine
        : Optional[zio.aws.backupgateway.model.VirtualMachineDetails.ReadOnly]
    def getVirtualMachine: ZIO[
      Any,
      AwsError,
      zio.aws.backupgateway.model.VirtualMachineDetails.ReadOnly
    ] = AwsError.unwrapOptionField("virtualMachine", virtualMachine)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.GetVirtualMachineResponse
  ) extends zio.aws.backupgateway.model.GetVirtualMachineResponse.ReadOnly {
    override val virtualMachine
        : Optional[zio.aws.backupgateway.model.VirtualMachineDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualMachine())
        .map(value =>
          zio.aws.backupgateway.model.VirtualMachineDetails.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.GetVirtualMachineResponse
  ): zio.aws.backupgateway.model.GetVirtualMachineResponse.ReadOnly =
    new Wrapper(impl)
}
