package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backupgateway.model.primitives.GatewayArn
import scala.jdk.CollectionConverters._
final case class PutBandwidthRateLimitScheduleRequest(
    bandwidthRateLimitIntervals: Iterable[
      zio.aws.backupgateway.model.BandwidthRateLimitInterval
    ],
    gatewayArn: GatewayArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.PutBandwidthRateLimitScheduleRequest = {
    import PutBandwidthRateLimitScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.PutBandwidthRateLimitScheduleRequest
      .builder()
      .bandwidthRateLimitIntervals(bandwidthRateLimitIntervals.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .gatewayArn(GatewayArn.unwrap(gatewayArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.PutBandwidthRateLimitScheduleRequest.ReadOnly =
    zio.aws.backupgateway.model.PutBandwidthRateLimitScheduleRequest
      .wrap(buildAwsValue())
}
object PutBandwidthRateLimitScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.PutBandwidthRateLimitScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backupgateway.model.PutBandwidthRateLimitScheduleRequest =
      zio.aws.backupgateway.model.PutBandwidthRateLimitScheduleRequest(
        bandwidthRateLimitIntervals.map { item =>
          item.asEditable
        },
        gatewayArn
      )
    def bandwidthRateLimitIntervals
        : List[zio.aws.backupgateway.model.BandwidthRateLimitInterval.ReadOnly]
    def gatewayArn: GatewayArn
    def getBandwidthRateLimitIntervals: ZIO[Any, Nothing, List[
      zio.aws.backupgateway.model.BandwidthRateLimitInterval.ReadOnly
    ]] = ZIO.succeed(bandwidthRateLimitIntervals)
    def getGatewayArn: ZIO[Any, Nothing, GatewayArn] = ZIO.succeed(gatewayArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.PutBandwidthRateLimitScheduleRequest
  ) extends zio.aws.backupgateway.model.PutBandwidthRateLimitScheduleRequest.ReadOnly {
    override val bandwidthRateLimitIntervals: List[
      zio.aws.backupgateway.model.BandwidthRateLimitInterval.ReadOnly
    ] = impl
      .bandwidthRateLimitIntervals()
      .asScala
      .map { item =>
        zio.aws.backupgateway.model.BandwidthRateLimitInterval.wrap(item)
      }
      .toList
    override val gatewayArn: GatewayArn =
      zio.aws.backupgateway.model.primitives.GatewayArn(impl.gatewayArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.PutBandwidthRateLimitScheduleRequest
  ): zio.aws.backupgateway.model.PutBandwidthRateLimitScheduleRequest.ReadOnly =
    new Wrapper(impl)
}
