package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backupgateway.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class GetVirtualMachineRequest(resourceArn: ResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.GetVirtualMachineRequest = {
    import GetVirtualMachineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.GetVirtualMachineRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.GetVirtualMachineRequest.ReadOnly =
    zio.aws.backupgateway.model.GetVirtualMachineRequest.wrap(buildAwsValue())
}
object GetVirtualMachineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.GetVirtualMachineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.GetVirtualMachineRequest =
      zio.aws.backupgateway.model.GetVirtualMachineRequest(resourceArn)
    def resourceArn: ResourceArn
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.GetVirtualMachineRequest
  ) extends zio.aws.backupgateway.model.GetVirtualMachineRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.backupgateway.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.GetVirtualMachineRequest
  ): zio.aws.backupgateway.model.GetVirtualMachineRequest.ReadOnly =
    new Wrapper(impl)
}
