package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backupgateway.model.primitives.ServerArn
import scala.jdk.CollectionConverters._
final case class GetHypervisorRequest(hypervisorArn: ServerArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.GetHypervisorRequest = {
    import GetHypervisorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.GetHypervisorRequest
      .builder()
      .hypervisorArn(ServerArn.unwrap(hypervisorArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.GetHypervisorRequest.ReadOnly =
    zio.aws.backupgateway.model.GetHypervisorRequest.wrap(buildAwsValue())
}
object GetHypervisorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.GetHypervisorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.GetHypervisorRequest =
      zio.aws.backupgateway.model.GetHypervisorRequest(hypervisorArn)
    def hypervisorArn: ServerArn
    def getHypervisorArn: ZIO[Any, Nothing, ServerArn] =
      ZIO.succeed(hypervisorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.GetHypervisorRequest
  ) extends zio.aws.backupgateway.model.GetHypervisorRequest.ReadOnly {
    override val hypervisorArn: ServerArn =
      zio.aws.backupgateway.model.primitives.ServerArn(impl.hypervisorArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.GetHypervisorRequest
  ): zio.aws.backupgateway.model.GetHypervisorRequest.ReadOnly = new Wrapper(
    impl
  )
}
