package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.backupgateway.model.primitives.GatewayArn
import scala.jdk.CollectionConverters._
final case class GetBandwidthRateLimitScheduleResponse(
    bandwidthRateLimitIntervals: Optional[
      Iterable[zio.aws.backupgateway.model.BandwidthRateLimitInterval]
    ] = Optional.Absent,
    gatewayArn: Optional[GatewayArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.GetBandwidthRateLimitScheduleResponse = {
    import GetBandwidthRateLimitScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.GetBandwidthRateLimitScheduleResponse
      .builder()
      .optionallyWith(
        bandwidthRateLimitIntervals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bandwidthRateLimitIntervals)
      .optionallyWith(
        gatewayArn.map(value => GatewayArn.unwrap(value): java.lang.String)
      )(_.gatewayArn)
      .build()
  }
  def asReadOnly
      : zio.aws.backupgateway.model.GetBandwidthRateLimitScheduleResponse.ReadOnly =
    zio.aws.backupgateway.model.GetBandwidthRateLimitScheduleResponse
      .wrap(buildAwsValue())
}
object GetBandwidthRateLimitScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.GetBandwidthRateLimitScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backupgateway.model.GetBandwidthRateLimitScheduleResponse =
      zio.aws.backupgateway.model.GetBandwidthRateLimitScheduleResponse(
        bandwidthRateLimitIntervals.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        gatewayArn.map(value => value)
      )
    def bandwidthRateLimitIntervals: Optional[
      List[zio.aws.backupgateway.model.BandwidthRateLimitInterval.ReadOnly]
    ]
    def gatewayArn: Optional[GatewayArn]
    def getBandwidthRateLimitIntervals: ZIO[Any, AwsError, List[
      zio.aws.backupgateway.model.BandwidthRateLimitInterval.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "bandwidthRateLimitIntervals",
      bandwidthRateLimitIntervals
    )
    def getGatewayArn: ZIO[Any, AwsError, GatewayArn] =
      AwsError.unwrapOptionField("gatewayArn", gatewayArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.GetBandwidthRateLimitScheduleResponse
  ) extends zio.aws.backupgateway.model.GetBandwidthRateLimitScheduleResponse.ReadOnly {
    override val bandwidthRateLimitIntervals: Optional[
      List[zio.aws.backupgateway.model.BandwidthRateLimitInterval.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.bandwidthRateLimitIntervals())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.backupgateway.model.BandwidthRateLimitInterval.wrap(item)
        }.toList
      )
    override val gatewayArn: Optional[GatewayArn] = zio.aws.core.internal
      .optionalFromNullable(impl.gatewayArn())
      .map(value => zio.aws.backupgateway.model.primitives.GatewayArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.GetBandwidthRateLimitScheduleResponse
  ): zio.aws.backupgateway.model.GetBandwidthRateLimitScheduleResponse.ReadOnly =
    new Wrapper(impl)
}
