package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetHypervisorResponse(
    hypervisor: Optional[zio.aws.backupgateway.model.HypervisorDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.GetHypervisorResponse = {
    import GetHypervisorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.GetHypervisorResponse
      .builder()
      .optionallyWith(hypervisor.map(value => value.buildAwsValue()))(
        _.hypervisor
      )
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.GetHypervisorResponse.ReadOnly =
    zio.aws.backupgateway.model.GetHypervisorResponse.wrap(buildAwsValue())
}
object GetHypervisorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.GetHypervisorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.GetHypervisorResponse =
      zio.aws.backupgateway.model
        .GetHypervisorResponse(hypervisor.map(value => value.asEditable))
    def hypervisor
        : Optional[zio.aws.backupgateway.model.HypervisorDetails.ReadOnly]
    def getHypervisor: ZIO[
      Any,
      AwsError,
      zio.aws.backupgateway.model.HypervisorDetails.ReadOnly
    ] = AwsError.unwrapOptionField("hypervisor", hypervisor)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.GetHypervisorResponse
  ) extends zio.aws.backupgateway.model.GetHypervisorResponse.ReadOnly {
    override val hypervisor
        : Optional[zio.aws.backupgateway.model.HypervisorDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hypervisor())
        .map(value => zio.aws.backupgateway.model.HypervisorDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.GetHypervisorResponse
  ): zio.aws.backupgateway.model.GetHypervisorResponse.ReadOnly = new Wrapper(
    impl
  )
}
