package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backupgateway.model.primitives.ServerArn
import scala.jdk.CollectionConverters._
final case class DeleteHypervisorRequest(hypervisorArn: ServerArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.DeleteHypervisorRequest = {
    import DeleteHypervisorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.DeleteHypervisorRequest
      .builder()
      .hypervisorArn(ServerArn.unwrap(hypervisorArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.DeleteHypervisorRequest.ReadOnly =
    zio.aws.backupgateway.model.DeleteHypervisorRequest.wrap(buildAwsValue())
}
object DeleteHypervisorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.DeleteHypervisorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.DeleteHypervisorRequest =
      zio.aws.backupgateway.model.DeleteHypervisorRequest(hypervisorArn)
    def hypervisorArn: ServerArn
    def getHypervisorArn: ZIO[Any, Nothing, ServerArn] =
      ZIO.succeed(hypervisorArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.DeleteHypervisorRequest
  ) extends zio.aws.backupgateway.model.DeleteHypervisorRequest.ReadOnly {
    override val hypervisorArn: ServerArn =
      zio.aws.backupgateway.model.primitives.ServerArn(impl.hypervisorArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.DeleteHypervisorRequest
  ): zio.aws.backupgateway.model.DeleteHypervisorRequest.ReadOnly = new Wrapper(
    impl
  )
}
