package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backupgateway.model.primitives.ResourceArn
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceARN: ResourceArn,
    tags: Iterable[zio.aws.backupgateway.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.TagResourceRequest
      .builder()
      .resourceARN(ResourceArn.unwrap(resourceARN): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.TagResourceRequest.ReadOnly =
    zio.aws.backupgateway.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.TagResourceRequest =
      zio.aws.backupgateway.model.TagResourceRequest(
        resourceARN,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceARN: ResourceArn
    def tags: List[zio.aws.backupgateway.model.Tag.ReadOnly]
    def getResourceARN: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceARN)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.backupgateway.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.TagResourceRequest
  ) extends zio.aws.backupgateway.model.TagResourceRequest.ReadOnly {
    override val resourceARN: ResourceArn =
      zio.aws.backupgateway.model.primitives.ResourceArn(impl.resourceARN())
    override val tags: List[zio.aws.backupgateway.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.backupgateway.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.TagResourceRequest
  ): zio.aws.backupgateway.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
