package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backupgateway.model.primitives.GatewayArn
import scala.jdk.CollectionConverters._
final case class CreateGatewayResponse(gatewayArn: Option[GatewayArn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.CreateGatewayResponse = {
    import CreateGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.CreateGatewayResponse
      .builder()
      .optionallyWith(
        gatewayArn.map(value => GatewayArn.unwrap(value): java.lang.String)
      )(_.gatewayArn)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.CreateGatewayResponse.ReadOnly =
    zio.aws.backupgateway.model.CreateGatewayResponse.wrap(buildAwsValue())
}
object CreateGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backupgateway.model.CreateGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.CreateGatewayResponse =
      zio.aws.backupgateway.model
        .CreateGatewayResponse(gatewayArn.map(value => value))
    def gatewayArn: Option[GatewayArn]
    def getGatewayArn: ZIO[Any, AwsError, GatewayArn] =
      AwsError.unwrapOptionField("gatewayArn", gatewayArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.CreateGatewayResponse
  ) extends zio.aws.backupgateway.model.CreateGatewayResponse.ReadOnly {
    override val gatewayArn: Option[GatewayArn] = scala
      .Option(impl.gatewayArn())
      .map(value => zio.aws.backupgateway.model.primitives.GatewayArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.CreateGatewayResponse
  ): zio.aws.backupgateway.model.CreateGatewayResponse.ReadOnly = new Wrapper(
    impl
  )
}
