package zio.aws.backupgateway.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backupgateway.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters._
final case class Tag(key: TagKey, value: TagValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backupgateway.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backupgateway.model.Tag
      .builder()
      .key(TagKey.unwrap(key): java.lang.String)
      .value(TagValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backupgateway.model.Tag.ReadOnly =
    zio.aws.backupgateway.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.backupgateway.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backupgateway.model.Tag =
      zio.aws.backupgateway.model.Tag(key, value)
    def key: TagKey
    def value: TagValue
    def getKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, TagValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backupgateway.model.Tag
  ) extends zio.aws.backupgateway.model.Tag.ReadOnly {
    override val key: TagKey =
      zio.aws.backupgateway.model.primitives.TagKey(impl.key())
    override val value: TagValue =
      zio.aws.backupgateway.model.primitives.TagValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backupgateway.model.Tag
  ): zio.aws.backupgateway.model.Tag.ReadOnly = new Wrapper(impl)
}
