package zio.aws.backup.model
import scala.jdk.CollectionConverters._
sealed trait VaultState {
  def unwrap: software.amazon.awssdk.services.backup.model.VaultState
}
object VaultState {
  def wrap(
      value: software.amazon.awssdk.services.backup.model.VaultState
  ): zio.aws.backup.model.VaultState = value match {
    case software.amazon.awssdk.services.backup.model.VaultState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.backup.model.VaultState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.backup.model.VaultState.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.backup.model.VaultState.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.backup.model.VaultState {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.VaultState =
      software.amazon.awssdk.services.backup.model.VaultState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.backup.model.VaultState {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.VaultState =
      software.amazon.awssdk.services.backup.model.VaultState.CREATING
  }
  case object AVAILABLE extends zio.aws.backup.model.VaultState {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.VaultState =
      software.amazon.awssdk.services.backup.model.VaultState.AVAILABLE
  }
  case object FAILED extends zio.aws.backup.model.VaultState {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.VaultState =
      software.amazon.awssdk.services.backup.model.VaultState.FAILED
  }
}
