package zio.aws.backup.model
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{MaxResults, AccountId, BackupVaultName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListProtectedResourcesByBackupVaultRequest(
    backupVaultName: BackupVaultName,
    backupVaultAccountId: Optional[AccountId] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultRequest = {
    import ListProtectedResourcesByBackupVaultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultRequest
      .builder()
      .backupVaultName(
        BackupVaultName.unwrap(backupVaultName): java.lang.String
      )
      .optionallyWith(
        backupVaultAccountId.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.backupVaultAccountId)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.ListProtectedResourcesByBackupVaultRequest.ReadOnly =
    zio.aws.backup.model.ListProtectedResourcesByBackupVaultRequest
      .wrap(buildAwsValue())
}
object ListProtectedResourcesByBackupVaultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backup.model.ListProtectedResourcesByBackupVaultRequest =
      zio.aws.backup.model.ListProtectedResourcesByBackupVaultRequest(
        backupVaultName,
        backupVaultAccountId.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def backupVaultName: BackupVaultName
    def backupVaultAccountId: Optional[AccountId]
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def getBackupVaultName: ZIO[Any, Nothing, BackupVaultName] =
      ZIO.succeed(backupVaultName)
    def getBackupVaultAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("backupVaultAccountId", backupVaultAccountId)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultRequest
  ) extends zio.aws.backup.model.ListProtectedResourcesByBackupVaultRequest.ReadOnly {
    override val backupVaultName: BackupVaultName =
      zio.aws.backup.model.primitives.BackupVaultName(impl.backupVaultName())
    override val backupVaultAccountId: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupVaultAccountId())
        .map(value => zio.aws.backup.model.primitives.AccountId(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.backup.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultRequest
  ): zio.aws.backup.model.ListProtectedResourcesByBackupVaultRequest.ReadOnly =
    new Wrapper(impl)
}
