package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.backup.model.primitives.{ARN, BackupVaultName}
import scala.jdk.CollectionConverters._
final case class DisassociateRecoveryPointFromParentRequest(
    backupVaultName: BackupVaultName,
    recoveryPointArn: ARN
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointFromParentRequest = {
    import DisassociateRecoveryPointFromParentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointFromParentRequest
      .builder()
      .backupVaultName(
        BackupVaultName.unwrap(backupVaultName): java.lang.String
      )
      .recoveryPointArn(ARN.unwrap(recoveryPointArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.DisassociateRecoveryPointFromParentRequest.ReadOnly =
    zio.aws.backup.model.DisassociateRecoveryPointFromParentRequest
      .wrap(buildAwsValue())
}
object DisassociateRecoveryPointFromParentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointFromParentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backup.model.DisassociateRecoveryPointFromParentRequest =
      zio.aws.backup.model.DisassociateRecoveryPointFromParentRequest(
        backupVaultName,
        recoveryPointArn
      )
    def backupVaultName: BackupVaultName
    def recoveryPointArn: ARN
    def getBackupVaultName: ZIO[Any, Nothing, BackupVaultName] =
      ZIO.succeed(backupVaultName)
    def getRecoveryPointArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(recoveryPointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointFromParentRequest
  ) extends zio.aws.backup.model.DisassociateRecoveryPointFromParentRequest.ReadOnly {
    override val backupVaultName: BackupVaultName =
      zio.aws.backup.model.primitives.BackupVaultName(impl.backupVaultName())
    override val recoveryPointArn: ARN =
      zio.aws.backup.model.primitives.ARN(impl.recoveryPointArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointFromParentRequest
  ): zio.aws.backup.model.DisassociateRecoveryPointFromParentRequest.ReadOnly =
    new Wrapper(impl)
}
