package zio.aws.backup.model
import scala.jdk.CollectionConverters._
sealed trait VaultType {
  def unwrap: software.amazon.awssdk.services.backup.model.VaultType
}
object VaultType {
  def wrap(
      value: software.amazon.awssdk.services.backup.model.VaultType
  ): zio.aws.backup.model.VaultType = value match {
    case software.amazon.awssdk.services.backup.model.VaultType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.backup.model.VaultType.BACKUP_VAULT =>
      val r = BACKUP_VAULT
      r
    case software.amazon.awssdk.services.backup.model.VaultType.LOGICALLY_AIR_GAPPED_BACKUP_VAULT =>
      val r = LOGICALLY_AIR_GAPPED_BACKUP_VAULT
      r
  }
  case object unknownToSdkVersion extends zio.aws.backup.model.VaultType {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.VaultType =
      software.amazon.awssdk.services.backup.model.VaultType.UNKNOWN_TO_SDK_VERSION
  }
  case object BACKUP_VAULT extends zio.aws.backup.model.VaultType {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.VaultType =
      software.amazon.awssdk.services.backup.model.VaultType.BACKUP_VAULT
  }
  case object LOGICALLY_AIR_GAPPED_BACKUP_VAULT
      extends zio.aws.backup.model.VaultType {
    override def unwrap
        : software.amazon.awssdk.services.backup.model.VaultType =
      software.amazon.awssdk.services.backup.model.VaultType.LOGICALLY_AIR_GAPPED_BACKUP_VAULT
  }
}
