package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{
  AccountId,
  Timestamp,
  BackupVaultName,
  ResourceType,
  MaxResults,
  ARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRecoveryPointsByBackupVaultRequest(
    backupVaultName: BackupVaultName,
    backupVaultAccountId: Optional[AccountId] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    byResourceArn: Optional[ARN] = Optional.Absent,
    byResourceType: Optional[ResourceType] = Optional.Absent,
    byBackupPlanId: Optional[String] = Optional.Absent,
    byCreatedBefore: Optional[Timestamp] = Optional.Absent,
    byCreatedAfter: Optional[Timestamp] = Optional.Absent,
    byParentRecoveryPointArn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest = {
    import ListRecoveryPointsByBackupVaultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest
      .builder()
      .backupVaultName(
        BackupVaultName.unwrap(backupVaultName): java.lang.String
      )
      .optionallyWith(
        backupVaultAccountId.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.backupVaultAccountId)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        byResourceArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.byResourceArn)
      .optionallyWith(
        byResourceType.map(value =>
          ResourceType.unwrap(value): java.lang.String
        )
      )(_.byResourceType)
      .optionallyWith(byBackupPlanId.map(value => value: java.lang.String))(
        _.byBackupPlanId
      )
      .optionallyWith(
        byCreatedBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.byCreatedBefore)
      .optionallyWith(
        byCreatedAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.byCreatedAfter)
      .optionallyWith(
        byParentRecoveryPointArn.map(value =>
          ARN.unwrap(value): java.lang.String
        )
      )(_.byParentRecoveryPointArn)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.ListRecoveryPointsByBackupVaultRequest.ReadOnly =
    zio.aws.backup.model.ListRecoveryPointsByBackupVaultRequest
      .wrap(buildAwsValue())
}
object ListRecoveryPointsByBackupVaultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backup.model.ListRecoveryPointsByBackupVaultRequest =
      zio.aws.backup.model.ListRecoveryPointsByBackupVaultRequest(
        backupVaultName,
        backupVaultAccountId.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        byResourceArn.map(value => value),
        byResourceType.map(value => value),
        byBackupPlanId.map(value => value),
        byCreatedBefore.map(value => value),
        byCreatedAfter.map(value => value),
        byParentRecoveryPointArn.map(value => value)
      )
    def backupVaultName: BackupVaultName
    def backupVaultAccountId: Optional[AccountId]
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def byResourceArn: Optional[ARN]
    def byResourceType: Optional[ResourceType]
    def byBackupPlanId: Optional[String]
    def byCreatedBefore: Optional[Timestamp]
    def byCreatedAfter: Optional[Timestamp]
    def byParentRecoveryPointArn: Optional[ARN]
    def getBackupVaultName: ZIO[Any, Nothing, BackupVaultName] =
      ZIO.succeed(backupVaultName)
    def getBackupVaultAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("backupVaultAccountId", backupVaultAccountId)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getByResourceArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("byResourceArn", byResourceArn)
    def getByResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("byResourceType", byResourceType)
    def getByBackupPlanId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("byBackupPlanId", byBackupPlanId)
    def getByCreatedBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("byCreatedBefore", byCreatedBefore)
    def getByCreatedAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("byCreatedAfter", byCreatedAfter)
    def getByParentRecoveryPointArn: ZIO[Any, AwsError, ARN] = AwsError
      .unwrapOptionField("byParentRecoveryPointArn", byParentRecoveryPointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest
  ) extends zio.aws.backup.model.ListRecoveryPointsByBackupVaultRequest.ReadOnly {
    override val backupVaultName: BackupVaultName =
      zio.aws.backup.model.primitives.BackupVaultName(impl.backupVaultName())
    override val backupVaultAccountId: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupVaultAccountId())
        .map(value => zio.aws.backup.model.primitives.AccountId(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.backup.model.primitives.MaxResults(value))
    override val byResourceArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.byResourceArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val byResourceType: Optional[ResourceType] = zio.aws.core.internal
      .optionalFromNullable(impl.byResourceType())
      .map(value => zio.aws.backup.model.primitives.ResourceType(value))
    override val byBackupPlanId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.byBackupPlanId())
      .map(value => value: String)
    override val byCreatedBefore: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.byCreatedBefore())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val byCreatedAfter: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.byCreatedAfter())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val byParentRecoveryPointArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.byParentRecoveryPointArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest
  ): zio.aws.backup.model.ListRecoveryPointsByBackupVaultRequest.ReadOnly =
    new Wrapper(impl)
}
