package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListProtectedResourcesByBackupVaultResponse(
    results: Optional[Iterable[zio.aws.backup.model.ProtectedResource]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultResponse = {
    import ListProtectedResourcesByBackupVaultResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultResponse
      .builder()
      .optionallyWith(
        results.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.results)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.ListProtectedResourcesByBackupVaultResponse.ReadOnly =
    zio.aws.backup.model.ListProtectedResourcesByBackupVaultResponse
      .wrap(buildAwsValue())
}
object ListProtectedResourcesByBackupVaultResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backup.model.ListProtectedResourcesByBackupVaultResponse =
      zio.aws.backup.model.ListProtectedResourcesByBackupVaultResponse(
        results.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def results: Optional[List[zio.aws.backup.model.ProtectedResource.ReadOnly]]
    def nextToken: Optional[String]
    def getResults: ZIO[Any, AwsError, List[
      zio.aws.backup.model.ProtectedResource.ReadOnly
    ]] = AwsError.unwrapOptionField("results", results)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultResponse
  ) extends zio.aws.backup.model.ListProtectedResourcesByBackupVaultResponse.ReadOnly {
    override val results
        : Optional[List[zio.aws.backup.model.ProtectedResource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.results())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.ProtectedResource.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListProtectedResourcesByBackupVaultResponse
  ): zio.aws.backup.model.ListProtectedResourcesByBackupVaultResponse.ReadOnly =
    new Wrapper(impl)
}
