package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{Timestamp, ARN, BackupVaultName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CreateLogicallyAirGappedBackupVaultResponse(
    backupVaultName: Optional[BackupVaultName] = Optional.Absent,
    backupVaultArn: Optional[ARN] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    vaultState: Optional[zio.aws.backup.model.VaultState] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.CreateLogicallyAirGappedBackupVaultResponse = {
    import CreateLogicallyAirGappedBackupVaultResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.CreateLogicallyAirGappedBackupVaultResponse
      .builder()
      .optionallyWith(
        backupVaultName.map(value =>
          BackupVaultName.unwrap(value): java.lang.String
        )
      )(_.backupVaultName)
      .optionallyWith(
        backupVaultArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.backupVaultArn)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(vaultState.map(value => value.unwrap))(_.vaultState)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.CreateLogicallyAirGappedBackupVaultResponse.ReadOnly =
    zio.aws.backup.model.CreateLogicallyAirGappedBackupVaultResponse
      .wrap(buildAwsValue())
}
object CreateLogicallyAirGappedBackupVaultResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.CreateLogicallyAirGappedBackupVaultResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backup.model.CreateLogicallyAirGappedBackupVaultResponse =
      zio.aws.backup.model.CreateLogicallyAirGappedBackupVaultResponse(
        backupVaultName.map(value => value),
        backupVaultArn.map(value => value),
        creationDate.map(value => value),
        vaultState.map(value => value)
      )
    def backupVaultName: Optional[BackupVaultName]
    def backupVaultArn: Optional[ARN]
    def creationDate: Optional[Timestamp]
    def vaultState: Optional[zio.aws.backup.model.VaultState]
    def getBackupVaultName: ZIO[Any, AwsError, BackupVaultName] =
      AwsError.unwrapOptionField("backupVaultName", backupVaultName)
    def getBackupVaultArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("backupVaultArn", backupVaultArn)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getVaultState: ZIO[Any, AwsError, zio.aws.backup.model.VaultState] =
      AwsError.unwrapOptionField("vaultState", vaultState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.CreateLogicallyAirGappedBackupVaultResponse
  ) extends zio.aws.backup.model.CreateLogicallyAirGappedBackupVaultResponse.ReadOnly {
    override val backupVaultName: Optional[BackupVaultName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupVaultName())
        .map(value => zio.aws.backup.model.primitives.BackupVaultName(value))
    override val backupVaultArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.backupVaultArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val vaultState: Optional[zio.aws.backup.model.VaultState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vaultState())
        .map(value => zio.aws.backup.model.VaultState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.CreateLogicallyAirGappedBackupVaultResponse
  ): zio.aws.backup.model.CreateLogicallyAirGappedBackupVaultResponse.ReadOnly =
    new Wrapper(impl)
}
