package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{
  Timestamp,
  FrameworkDescription,
  ARN,
  FrameworkName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeFrameworkResponse(
    frameworkName: Optional[FrameworkName] = Optional.Absent,
    frameworkArn: Optional[ARN] = Optional.Absent,
    frameworkDescription: Optional[FrameworkDescription] = Optional.Absent,
    frameworkControls: Optional[
      Iterable[zio.aws.backup.model.FrameworkControl]
    ] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    deploymentStatus: Optional[String] = Optional.Absent,
    frameworkStatus: Optional[String] = Optional.Absent,
    idempotencyToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DescribeFrameworkResponse = {
    import DescribeFrameworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DescribeFrameworkResponse
      .builder()
      .optionallyWith(
        frameworkName.map(value =>
          FrameworkName.unwrap(value): java.lang.String
        )
      )(_.frameworkName)
      .optionallyWith(
        frameworkArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.frameworkArn)
      .optionallyWith(
        frameworkDescription.map(value =>
          FrameworkDescription.unwrap(value): java.lang.String
        )
      )(_.frameworkDescription)
      .optionallyWith(
        frameworkControls.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.frameworkControls)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(deploymentStatus.map(value => value: java.lang.String))(
        _.deploymentStatus
      )
      .optionallyWith(frameworkStatus.map(value => value: java.lang.String))(
        _.frameworkStatus
      )
      .optionallyWith(idempotencyToken.map(value => value: java.lang.String))(
        _.idempotencyToken
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DescribeFrameworkResponse.ReadOnly =
    zio.aws.backup.model.DescribeFrameworkResponse.wrap(buildAwsValue())
}
object DescribeFrameworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DescribeFrameworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DescribeFrameworkResponse =
      zio.aws.backup.model.DescribeFrameworkResponse(
        frameworkName.map(value => value),
        frameworkArn.map(value => value),
        frameworkDescription.map(value => value),
        frameworkControls.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationTime.map(value => value),
        deploymentStatus.map(value => value),
        frameworkStatus.map(value => value),
        idempotencyToken.map(value => value)
      )
    def frameworkName: Optional[FrameworkName]
    def frameworkArn: Optional[ARN]
    def frameworkDescription: Optional[FrameworkDescription]
    def frameworkControls
        : Optional[List[zio.aws.backup.model.FrameworkControl.ReadOnly]]
    def creationTime: Optional[Timestamp]
    def deploymentStatus: Optional[String]
    def frameworkStatus: Optional[String]
    def idempotencyToken: Optional[String]
    def getFrameworkName: ZIO[Any, AwsError, FrameworkName] =
      AwsError.unwrapOptionField("frameworkName", frameworkName)
    def getFrameworkArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("frameworkArn", frameworkArn)
    def getFrameworkDescription: ZIO[Any, AwsError, FrameworkDescription] =
      AwsError.unwrapOptionField("frameworkDescription", frameworkDescription)
    def getFrameworkControls: ZIO[Any, AwsError, List[
      zio.aws.backup.model.FrameworkControl.ReadOnly
    ]] = AwsError.unwrapOptionField("frameworkControls", frameworkControls)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDeploymentStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deploymentStatus", deploymentStatus)
    def getFrameworkStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("frameworkStatus", frameworkStatus)
    def getIdempotencyToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DescribeFrameworkResponse
  ) extends zio.aws.backup.model.DescribeFrameworkResponse.ReadOnly {
    override val frameworkName: Optional[FrameworkName] = zio.aws.core.internal
      .optionalFromNullable(impl.frameworkName())
      .map(value => zio.aws.backup.model.primitives.FrameworkName(value))
    override val frameworkArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.frameworkArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val frameworkDescription: Optional[FrameworkDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.frameworkDescription())
        .map(value =>
          zio.aws.backup.model.primitives.FrameworkDescription(value)
        )
    override val frameworkControls
        : Optional[List[zio.aws.backup.model.FrameworkControl.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.frameworkControls())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.FrameworkControl.wrap(item)
          }.toList
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val deploymentStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentStatus())
      .map(value => value: String)
    override val frameworkStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.frameworkStatus())
      .map(value => value: String)
    override val idempotencyToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.idempotencyToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DescribeFrameworkResponse
  ): zio.aws.backup.model.DescribeFrameworkResponse.ReadOnly = new Wrapper(impl)
}
