package zio.aws.backup.model
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.MaxResults
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListBackupPlanTemplatesRequest(
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest = {
    import ListBackupPlanTemplatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListBackupPlanTemplatesRequest.ReadOnly =
    zio.aws.backup.model.ListBackupPlanTemplatesRequest.wrap(buildAwsValue())
}
object ListBackupPlanTemplatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListBackupPlanTemplatesRequest =
      zio.aws.backup.model.ListBackupPlanTemplatesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest
  ) extends zio.aws.backup.model.ListBackupPlanTemplatesRequest.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.backup.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest
  ): zio.aws.backup.model.ListBackupPlanTemplatesRequest.ReadOnly = new Wrapper(
    impl
  )
}
