package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{AccountId, ARN, BackupVaultName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetRecoveryPointRestoreMetadataRequest(
    backupVaultName: BackupVaultName,
    recoveryPointArn: ARN,
    backupVaultAccountId: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataRequest = {
    import GetRecoveryPointRestoreMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataRequest
      .builder()
      .backupVaultName(
        BackupVaultName.unwrap(backupVaultName): java.lang.String
      )
      .recoveryPointArn(ARN.unwrap(recoveryPointArn): java.lang.String)
      .optionallyWith(
        backupVaultAccountId.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.backupVaultAccountId)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.GetRecoveryPointRestoreMetadataRequest.ReadOnly =
    zio.aws.backup.model.GetRecoveryPointRestoreMetadataRequest
      .wrap(buildAwsValue())
}
object GetRecoveryPointRestoreMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backup.model.GetRecoveryPointRestoreMetadataRequest =
      zio.aws.backup.model.GetRecoveryPointRestoreMetadataRequest(
        backupVaultName,
        recoveryPointArn,
        backupVaultAccountId.map(value => value)
      )
    def backupVaultName: BackupVaultName
    def recoveryPointArn: ARN
    def backupVaultAccountId: Optional[AccountId]
    def getBackupVaultName: ZIO[Any, Nothing, BackupVaultName] =
      ZIO.succeed(backupVaultName)
    def getRecoveryPointArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(recoveryPointArn)
    def getBackupVaultAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("backupVaultAccountId", backupVaultAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataRequest
  ) extends zio.aws.backup.model.GetRecoveryPointRestoreMetadataRequest.ReadOnly {
    override val backupVaultName: BackupVaultName =
      zio.aws.backup.model.primitives.BackupVaultName(impl.backupVaultName())
    override val recoveryPointArn: ARN =
      zio.aws.backup.model.primitives.ARN(impl.recoveryPointArn())
    override val backupVaultAccountId: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupVaultAccountId())
        .map(value => zio.aws.backup.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataRequest
  ): zio.aws.backup.model.GetRecoveryPointRestoreMetadataRequest.ReadOnly =
    new Wrapper(impl)
}
