package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{TagValue, TagKey, BackupVaultName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLogicallyAirGappedBackupVaultRequest(
    backupVaultName: BackupVaultName,
    backupVaultTags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    creatorRequestId: Optional[String] = Optional.Absent,
    minRetentionDays: Long,
    maxRetentionDays: Long
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.CreateLogicallyAirGappedBackupVaultRequest = {
    import CreateLogicallyAirGappedBackupVaultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.CreateLogicallyAirGappedBackupVaultRequest
      .builder()
      .backupVaultName(
        BackupVaultName.unwrap(backupVaultName): java.lang.String
      )
      .optionallyWith(
        backupVaultTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.backupVaultTags)
      .optionallyWith(creatorRequestId.map(value => value: java.lang.String))(
        _.creatorRequestId
      )
      .minRetentionDays(minRetentionDays: java.lang.Long)
      .maxRetentionDays(maxRetentionDays: java.lang.Long)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.CreateLogicallyAirGappedBackupVaultRequest.ReadOnly =
    zio.aws.backup.model.CreateLogicallyAirGappedBackupVaultRequest
      .wrap(buildAwsValue())
}
object CreateLogicallyAirGappedBackupVaultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.CreateLogicallyAirGappedBackupVaultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backup.model.CreateLogicallyAirGappedBackupVaultRequest =
      zio.aws.backup.model.CreateLogicallyAirGappedBackupVaultRequest(
        backupVaultName,
        backupVaultTags.map(value => value),
        creatorRequestId.map(value => value),
        minRetentionDays,
        maxRetentionDays
      )
    def backupVaultName: BackupVaultName
    def backupVaultTags: Optional[Map[TagKey, TagValue]]
    def creatorRequestId: Optional[String]
    def minRetentionDays: Long
    def maxRetentionDays: Long
    def getBackupVaultName: ZIO[Any, Nothing, BackupVaultName] =
      ZIO.succeed(backupVaultName)
    def getBackupVaultTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("backupVaultTags", backupVaultTags)
    def getCreatorRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
    def getMinRetentionDays: ZIO[Any, Nothing, Long] =
      ZIO.succeed(minRetentionDays)
    def getMaxRetentionDays: ZIO[Any, Nothing, Long] =
      ZIO.succeed(maxRetentionDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.CreateLogicallyAirGappedBackupVaultRequest
  ) extends zio.aws.backup.model.CreateLogicallyAirGappedBackupVaultRequest.ReadOnly {
    override val backupVaultName: BackupVaultName =
      zio.aws.backup.model.primitives.BackupVaultName(impl.backupVaultName())
    override val backupVaultTags: Optional[Map[TagKey, TagValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupVaultTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.backup.model.primitives
                .TagKey(key) -> zio.aws.backup.model.primitives.TagValue(value)
            })
            .toMap
        )
    override val creatorRequestId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.creatorRequestId())
      .map(value => value: String)
    override val minRetentionDays: Long = impl.minRetentionDays(): Long
    override val maxRetentionDays: Long = impl.maxRetentionDays(): Long
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.CreateLogicallyAirGappedBackupVaultRequest
  ): zio.aws.backup.model.CreateLogicallyAirGappedBackupVaultRequest.ReadOnly =
    new Wrapper(impl)
}
