package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{
  BackupRuleName,
  BackupVaultName,
  TagValue,
  CronExpression,
  WindowMinutes,
  Timezone,
  TagKey
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BackupRule(
    ruleName: BackupRuleName,
    targetBackupVaultName: BackupVaultName,
    scheduleExpression: Optional[CronExpression] = Optional.Absent,
    startWindowMinutes: Optional[WindowMinutes] = Optional.Absent,
    completionWindowMinutes: Optional[WindowMinutes] = Optional.Absent,
    lifecycle: Optional[zio.aws.backup.model.Lifecycle] = Optional.Absent,
    recoveryPointTags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    ruleId: Optional[String] = Optional.Absent,
    copyActions: Optional[Iterable[zio.aws.backup.model.CopyAction]] =
      Optional.Absent,
    enableContinuousBackup: Optional[Boolean] = Optional.Absent,
    scheduleExpressionTimezone: Optional[Timezone] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.BackupRule = {
    import BackupRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.BackupRule
      .builder()
      .ruleName(BackupRuleName.unwrap(ruleName): java.lang.String)
      .targetBackupVaultName(
        BackupVaultName.unwrap(targetBackupVaultName): java.lang.String
      )
      .optionallyWith(
        scheduleExpression.map(value =>
          CronExpression.unwrap(value): java.lang.String
        )
      )(_.scheduleExpression)
      .optionallyWith(
        startWindowMinutes.map(value =>
          WindowMinutes.unwrap(value): java.lang.Long
        )
      )(_.startWindowMinutes)
      .optionallyWith(
        completionWindowMinutes.map(value =>
          WindowMinutes.unwrap(value): java.lang.Long
        )
      )(_.completionWindowMinutes)
      .optionallyWith(lifecycle.map(value => value.buildAwsValue()))(
        _.lifecycle
      )
      .optionallyWith(
        recoveryPointTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.recoveryPointTags)
      .optionallyWith(ruleId.map(value => value: java.lang.String))(_.ruleId)
      .optionallyWith(
        copyActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.copyActions)
      .optionallyWith(
        enableContinuousBackup.map(value => value: java.lang.Boolean)
      )(_.enableContinuousBackup)
      .optionallyWith(
        scheduleExpressionTimezone.map(value =>
          Timezone.unwrap(value): java.lang.String
        )
      )(_.scheduleExpressionTimezone)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.BackupRule.ReadOnly =
    zio.aws.backup.model.BackupRule.wrap(buildAwsValue())
}
object BackupRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.backup.model.BackupRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.BackupRule =
      zio.aws.backup.model.BackupRule(
        ruleName,
        targetBackupVaultName,
        scheduleExpression.map(value => value),
        startWindowMinutes.map(value => value),
        completionWindowMinutes.map(value => value),
        lifecycle.map(value => value.asEditable),
        recoveryPointTags.map(value => value),
        ruleId.map(value => value),
        copyActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        enableContinuousBackup.map(value => value),
        scheduleExpressionTimezone.map(value => value)
      )
    def ruleName: BackupRuleName
    def targetBackupVaultName: BackupVaultName
    def scheduleExpression: Optional[CronExpression]
    def startWindowMinutes: Optional[WindowMinutes]
    def completionWindowMinutes: Optional[WindowMinutes]
    def lifecycle: Optional[zio.aws.backup.model.Lifecycle.ReadOnly]
    def recoveryPointTags: Optional[Map[TagKey, TagValue]]
    def ruleId: Optional[String]
    def copyActions: Optional[List[zio.aws.backup.model.CopyAction.ReadOnly]]
    def enableContinuousBackup: Optional[Boolean]
    def scheduleExpressionTimezone: Optional[Timezone]
    def getRuleName: ZIO[Any, Nothing, BackupRuleName] = ZIO.succeed(ruleName)
    def getTargetBackupVaultName: ZIO[Any, Nothing, BackupVaultName] =
      ZIO.succeed(targetBackupVaultName)
    def getScheduleExpression: ZIO[Any, AwsError, CronExpression] =
      AwsError.unwrapOptionField("scheduleExpression", scheduleExpression)
    def getStartWindowMinutes: ZIO[Any, AwsError, WindowMinutes] =
      AwsError.unwrapOptionField("startWindowMinutes", startWindowMinutes)
    def getCompletionWindowMinutes: ZIO[Any, AwsError, WindowMinutes] = AwsError
      .unwrapOptionField("completionWindowMinutes", completionWindowMinutes)
    def getLifecycle
        : ZIO[Any, AwsError, zio.aws.backup.model.Lifecycle.ReadOnly] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getRecoveryPointTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("recoveryPointTags", recoveryPointTags)
    def getRuleId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ruleId", ruleId)
    def getCopyActions
        : ZIO[Any, AwsError, List[zio.aws.backup.model.CopyAction.ReadOnly]] =
      AwsError.unwrapOptionField("copyActions", copyActions)
    def getEnableContinuousBackup: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableContinuousBackup", enableContinuousBackup)
    def getScheduleExpressionTimezone: ZIO[Any, AwsError, Timezone] =
      AwsError.unwrapOptionField(
        "scheduleExpressionTimezone",
        scheduleExpressionTimezone
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.BackupRule
  ) extends zio.aws.backup.model.BackupRule.ReadOnly {
    override val ruleName: BackupRuleName =
      zio.aws.backup.model.primitives.BackupRuleName(impl.ruleName())
    override val targetBackupVaultName: BackupVaultName =
      zio.aws.backup.model.primitives
        .BackupVaultName(impl.targetBackupVaultName())
    override val scheduleExpression: Optional[CronExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleExpression())
        .map(value => zio.aws.backup.model.primitives.CronExpression(value))
    override val startWindowMinutes: Optional[WindowMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startWindowMinutes())
        .map(value => zio.aws.backup.model.primitives.WindowMinutes(value))
    override val completionWindowMinutes: Optional[WindowMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completionWindowMinutes())
        .map(value => zio.aws.backup.model.primitives.WindowMinutes(value))
    override val lifecycle: Optional[zio.aws.backup.model.Lifecycle.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycle())
        .map(value => zio.aws.backup.model.Lifecycle.wrap(value))
    override val recoveryPointTags: Optional[Map[TagKey, TagValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recoveryPointTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.backup.model.primitives
                .TagKey(key) -> zio.aws.backup.model.primitives.TagValue(value)
            })
            .toMap
        )
    override val ruleId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleId())
      .map(value => value: String)
    override val copyActions
        : Optional[List[zio.aws.backup.model.CopyAction.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.CopyAction.wrap(item)
          }.toList
        )
    override val enableContinuousBackup: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableContinuousBackup())
        .map(value => value: Boolean)
    override val scheduleExpressionTimezone: Optional[Timezone] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleExpressionTimezone())
        .map(value => zio.aws.backup.model.primitives.Timezone(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.BackupRule
  ): zio.aws.backup.model.BackupRule.ReadOnly = new Wrapper(impl)
}
