package zio.aws.backup
import zio.prelude.Subtype
import zio.aws.backup.model.primitives.{
  GlobalSettingsName,
  TagValue,
  IsEnabled,
  ResourceType,
  BackupOptionKey,
  GlobalSettingsValue,
  MetadataValue,
  MetadataKey,
  BackupOptionValue,
  ARN,
  TagKey
}
import java.time.Instant
import zio.aws.backup.model.primitives.MaxResults.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ARN extends Subtype[String]
    type ARN = zio.aws.backup.model.primitives.ARN.Type
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.backup.model.primitives.AccountId.Type
    object BackupOptionKey extends Subtype[String]
    type BackupOptionKey = zio.aws.backup.model.primitives.BackupOptionKey.Type
    object BackupOptionValue extends Subtype[String]
    type BackupOptionValue =
      zio.aws.backup.model.primitives.BackupOptionValue.Type
    object BackupPlanName extends Subtype[String]
    type BackupPlanName = zio.aws.backup.model.primitives.BackupPlanName.Type
    object BackupRuleName extends Subtype[String]
    type BackupRuleName = zio.aws.backup.model.primitives.BackupRuleName.Type
    object BackupSelectionName extends Subtype[String]
    type BackupSelectionName =
      zio.aws.backup.model.primitives.BackupSelectionName.Type
    object BackupVaultName extends Subtype[String]
    type BackupVaultName = zio.aws.backup.model.primitives.BackupVaultName.Type
    object ConditionKey extends Subtype[String]
    type ConditionKey = zio.aws.backup.model.primitives.ConditionKey.Type
    object ConditionValue extends Subtype[String]
    type ConditionValue = zio.aws.backup.model.primitives.ConditionValue.Type
    object ControlName extends Subtype[String]
    type ControlName = zio.aws.backup.model.primitives.ControlName.Type
    object CronExpression extends Subtype[String]
    type CronExpression = zio.aws.backup.model.primitives.CronExpression.Type
    object FrameworkDescription extends Subtype[String]
    type FrameworkDescription =
      zio.aws.backup.model.primitives.FrameworkDescription.Type
    object FrameworkName extends Subtype[String]
    type FrameworkName = zio.aws.backup.model.primitives.FrameworkName.Type
    object GlobalSettingsName extends Subtype[String]
    type GlobalSettingsName =
      zio.aws.backup.model.primitives.GlobalSettingsName.Type
    object GlobalSettingsValue extends Subtype[String]
    type GlobalSettingsValue =
      zio.aws.backup.model.primitives.GlobalSettingsValue.Type
    object IAMPolicy extends Subtype[String]
    type IAMPolicy = zio.aws.backup.model.primitives.IAMPolicy.Type
    object IAMRoleArn extends Subtype[String]
    type IAMRoleArn = zio.aws.backup.model.primitives.IAMRoleArn.Type
    type Integer = Int
    object IsEnabled extends Subtype[Boolean]
    type IsEnabled = zio.aws.backup.model.primitives.IsEnabled.Type
    object MaxFrameworkInputs extends Subtype[Int]
    type MaxFrameworkInputs =
      zio.aws.backup.model.primitives.MaxFrameworkInputs.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.backup.model.primitives.MaxResults.Type
    object MetadataKey extends Subtype[String]
    type MetadataKey = zio.aws.backup.model.primitives.MetadataKey.Type
    object MetadataValue extends Subtype[String]
    type MetadataValue = zio.aws.backup.model.primitives.MetadataValue.Type
    object ParameterName extends Subtype[String]
    type ParameterName = zio.aws.backup.model.primitives.ParameterName.Type
    object ParameterValue extends Subtype[String]
    type ParameterValue = zio.aws.backup.model.primitives.ParameterValue.Type
    object ReportJobId extends Subtype[String]
    type ReportJobId = zio.aws.backup.model.primitives.ReportJobId.Type
    object ReportPlanDescription extends Subtype[String]
    type ReportPlanDescription =
      zio.aws.backup.model.primitives.ReportPlanDescription.Type
    object ReportPlanName extends Subtype[String]
    type ReportPlanName = zio.aws.backup.model.primitives.ReportPlanName.Type
    object ResourceType extends Subtype[String]
    type ResourceType = zio.aws.backup.model.primitives.ResourceType.Type
    object RestoreJobId extends Subtype[String]
    type RestoreJobId = zio.aws.backup.model.primitives.RestoreJobId.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.backup.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.backup.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.backup.model.primitives.Timestamp.Type
    object Timezone extends Subtype[String]
    type Timezone = zio.aws.backup.model.primitives.Timezone.Type
    object WindowMinutes extends Subtype[Long]
    type WindowMinutes = zio.aws.backup.model.primitives.WindowMinutes.Type
  }
  type AdvancedBackupSettings = List[zio.aws.backup.model.AdvancedBackupSetting]
  type BackupJobChildJobsInState =
    Map[zio.aws.backup.model.BackupJobState, Long]
  type BackupJobsList = List[zio.aws.backup.model.BackupJob]
  type BackupOptions = Map[BackupOptionKey, BackupOptionValue]
  type BackupPlanTemplatesList =
    List[zio.aws.backup.model.BackupPlanTemplatesListMember]
  type BackupPlanVersionsList = List[zio.aws.backup.model.BackupPlansListMember]
  type BackupPlansList = List[zio.aws.backup.model.BackupPlansListMember]
  type BackupRules = List[zio.aws.backup.model.BackupRule]
  type BackupRulesInput = List[zio.aws.backup.model.BackupRuleInput]
  type BackupSelectionsList =
    List[zio.aws.backup.model.BackupSelectionsListMember]
  type BackupVaultEvents = List[zio.aws.backup.model.BackupVaultEvent]
  type BackupVaultList = List[zio.aws.backup.model.BackupVaultListMember]
  type ComplianceResourceIdList = List[String]
  type ConditionParameters = List[zio.aws.backup.model.ConditionParameter]
  type ControlInputParameters = List[zio.aws.backup.model.ControlInputParameter]
  type CopyActions = List[zio.aws.backup.model.CopyAction]
  type CopyJobChildJobsInState = Map[zio.aws.backup.model.CopyJobState, Long]
  type CopyJobsList = List[zio.aws.backup.model.CopyJob]
  type FormatList = List[String]
  type FrameworkControls = List[zio.aws.backup.model.FrameworkControl]
  type FrameworkList = List[zio.aws.backup.model.Framework]
  type GlobalSettings = Map[GlobalSettingsName, GlobalSettingsValue]
  type LegalHoldsList = List[zio.aws.backup.model.LegalHold]
  type ListOfTags = List[zio.aws.backup.model.Condition]
  type Metadata = Map[MetadataKey, MetadataValue]
  type ProtectedResourcesList = List[zio.aws.backup.model.ProtectedResource]
  type RecoveryPointByBackupVaultList =
    List[zio.aws.backup.model.RecoveryPointByBackupVault]
  type RecoveryPointByResourceList =
    List[zio.aws.backup.model.RecoveryPointByResource]
  type RecoveryPointsList = List[zio.aws.backup.model.RecoveryPointMember]
  type ReportJobList = List[zio.aws.backup.model.ReportJob]
  type ReportPlanList = List[zio.aws.backup.model.ReportPlan]
  type ResourceArns = List[ARN]
  type ResourceIdentifiers = List[String]
  type ResourceTypeList = List[ARN]
  type ResourceTypeManagementPreference = Map[ResourceType, IsEnabled]
  type ResourceTypeOptInPreference = Map[ResourceType, IsEnabled]
  type ResourceTypes = List[ResourceType]
  type RestoreJobsList = List[zio.aws.backup.model.RestoreJobsListMember]
  type StringList = List[String]
  type StringMap = Map[String, String]
  type TagKeyList = List[String]
  type Tags = Map[TagKey, TagValue]
  type VaultNames = List[String]
}
