package zio.aws.backup.model
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.MaxResults
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListBackupVaultsRequest(
    byVaultType: Optional[zio.aws.backup.model.VaultType] = Optional.Absent,
    byShared: Optional[Boolean] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest = {
    import ListBackupVaultsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest
      .builder()
      .optionallyWith(byVaultType.map(value => value.unwrap))(_.byVaultType)
      .optionallyWith(byShared.map(value => value: java.lang.Boolean))(
        _.byShared
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListBackupVaultsRequest.ReadOnly =
    zio.aws.backup.model.ListBackupVaultsRequest.wrap(buildAwsValue())
}
object ListBackupVaultsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListBackupVaultsRequest =
      zio.aws.backup.model.ListBackupVaultsRequest(
        byVaultType.map(value => value),
        byShared.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def byVaultType: Optional[zio.aws.backup.model.VaultType]
    def byShared: Optional[Boolean]
    def nextToken: Optional[String]
    def maxResults: Optional[MaxResults]
    def getByVaultType: ZIO[Any, AwsError, zio.aws.backup.model.VaultType] =
      AwsError.unwrapOptionField("byVaultType", byVaultType)
    def getByShared: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("byShared", byShared)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest
  ) extends zio.aws.backup.model.ListBackupVaultsRequest.ReadOnly {
    override val byVaultType: Optional[zio.aws.backup.model.VaultType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.byVaultType())
        .map(value => zio.aws.backup.model.VaultType.wrap(value))
    override val byShared: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.byShared())
      .map(value => value: Boolean)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.backup.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest
  ): zio.aws.backup.model.ListBackupVaultsRequest.ReadOnly = new Wrapper(impl)
}
