package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{
  IAMRoleArn,
  ResourceType,
  MetadataValue,
  MetadataKey,
  ARN
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartRestoreJobRequest(
    recoveryPointArn: ARN,
    metadata: Map[MetadataKey, MetadataValue],
    iamRoleArn: Optional[IAMRoleArn] = Optional.Absent,
    idempotencyToken: Optional[String] = Optional.Absent,
    resourceType: Optional[ResourceType] = Optional.Absent,
    copySourceTagsToRestoredResource: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.StartRestoreJobRequest = {
    import StartRestoreJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.StartRestoreJobRequest
      .builder()
      .recoveryPointArn(ARN.unwrap(recoveryPointArn): java.lang.String)
      .metadata(
        metadata
          .map({ case (key, value) =>
            (MetadataKey.unwrap(key): java.lang.String) -> (MetadataValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .optionallyWith(
        iamRoleArn.map(value => IAMRoleArn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(idempotencyToken.map(value => value: java.lang.String))(
        _.idempotencyToken
      )
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .optionallyWith(
        copySourceTagsToRestoredResource.map(value => value: java.lang.Boolean)
      )(_.copySourceTagsToRestoredResource)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.StartRestoreJobRequest.ReadOnly =
    zio.aws.backup.model.StartRestoreJobRequest.wrap(buildAwsValue())
}
object StartRestoreJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.StartRestoreJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.StartRestoreJobRequest =
      zio.aws.backup.model.StartRestoreJobRequest(
        recoveryPointArn,
        metadata,
        iamRoleArn.map(value => value),
        idempotencyToken.map(value => value),
        resourceType.map(value => value),
        copySourceTagsToRestoredResource.map(value => value)
      )
    def recoveryPointArn: ARN
    def metadata: Map[MetadataKey, MetadataValue]
    def iamRoleArn: Optional[IAMRoleArn]
    def idempotencyToken: Optional[String]
    def resourceType: Optional[ResourceType]
    def copySourceTagsToRestoredResource: Optional[Boolean]
    def getRecoveryPointArn: ZIO[Any, Nothing, ARN] =
      ZIO.succeed(recoveryPointArn)
    def getMetadata: ZIO[Any, Nothing, Map[MetadataKey, MetadataValue]] =
      ZIO.succeed(metadata)
    def getIamRoleArn: ZIO[Any, AwsError, IAMRoleArn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getIdempotencyToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getCopySourceTagsToRestoredResource: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "copySourceTagsToRestoredResource",
        copySourceTagsToRestoredResource
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.StartRestoreJobRequest
  ) extends zio.aws.backup.model.StartRestoreJobRequest.ReadOnly {
    override val recoveryPointArn: ARN =
      zio.aws.backup.model.primitives.ARN(impl.recoveryPointArn())
    override val metadata: Map[MetadataKey, MetadataValue] = impl
      .metadata()
      .asScala
      .map({ case (key, value) =>
        zio.aws.backup.model.primitives.MetadataKey(
          key
        ) -> zio.aws.backup.model.primitives.MetadataValue(value)
      })
      .toMap
    override val iamRoleArn: Optional[IAMRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoleArn())
      .map(value => zio.aws.backup.model.primitives.IAMRoleArn(value))
    override val idempotencyToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.idempotencyToken())
      .map(value => value: String)
    override val resourceType: Optional[ResourceType] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => zio.aws.backup.model.primitives.ResourceType(value))
    override val copySourceTagsToRestoredResource: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copySourceTagsToRestoredResource())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.StartRestoreJobRequest
  ): zio.aws.backup.model.StartRestoreJobRequest.ReadOnly = new Wrapper(impl)
}
