package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.Timestamp
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetBackupSelectionResponse(
    backupSelection: Optional[zio.aws.backup.model.BackupSelection] =
      Optional.Absent,
    selectionId: Optional[String] = Optional.Absent,
    backupPlanId: Optional[String] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    creatorRequestId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.GetBackupSelectionResponse = {
    import GetBackupSelectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.GetBackupSelectionResponse
      .builder()
      .optionallyWith(backupSelection.map(value => value.buildAwsValue()))(
        _.backupSelection
      )
      .optionallyWith(selectionId.map(value => value: java.lang.String))(
        _.selectionId
      )
      .optionallyWith(backupPlanId.map(value => value: java.lang.String))(
        _.backupPlanId
      )
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(creatorRequestId.map(value => value: java.lang.String))(
        _.creatorRequestId
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.GetBackupSelectionResponse.ReadOnly =
    zio.aws.backup.model.GetBackupSelectionResponse.wrap(buildAwsValue())
}
object GetBackupSelectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.GetBackupSelectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.GetBackupSelectionResponse =
      zio.aws.backup.model.GetBackupSelectionResponse(
        backupSelection.map(value => value.asEditable),
        selectionId.map(value => value),
        backupPlanId.map(value => value),
        creationDate.map(value => value),
        creatorRequestId.map(value => value)
      )
    def backupSelection: Optional[zio.aws.backup.model.BackupSelection.ReadOnly]
    def selectionId: Optional[String]
    def backupPlanId: Optional[String]
    def creationDate: Optional[Timestamp]
    def creatorRequestId: Optional[String]
    def getBackupSelection
        : ZIO[Any, AwsError, zio.aws.backup.model.BackupSelection.ReadOnly] =
      AwsError.unwrapOptionField("backupSelection", backupSelection)
    def getSelectionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("selectionId", selectionId)
    def getBackupPlanId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupPlanId", backupPlanId)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getCreatorRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.GetBackupSelectionResponse
  ) extends zio.aws.backup.model.GetBackupSelectionResponse.ReadOnly {
    override val backupSelection
        : Optional[zio.aws.backup.model.BackupSelection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupSelection())
        .map(value => zio.aws.backup.model.BackupSelection.wrap(value))
    override val selectionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.selectionId())
      .map(value => value: String)
    override val backupPlanId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.backupPlanId())
      .map(value => value: String)
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val creatorRequestId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.creatorRequestId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.GetBackupSelectionResponse
  ): zio.aws.backup.model.GetBackupSelectionResponse.ReadOnly = new Wrapper(
    impl
  )
}
