package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{Timestamp, ARN, FrameworkName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class UpdateFrameworkResponse(
    frameworkName: Optional[FrameworkName] = Optional.Absent,
    frameworkArn: Optional[ARN] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.UpdateFrameworkResponse = {
    import UpdateFrameworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.UpdateFrameworkResponse
      .builder()
      .optionallyWith(
        frameworkName.map(value =>
          FrameworkName.unwrap(value): java.lang.String
        )
      )(_.frameworkName)
      .optionallyWith(
        frameworkArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.frameworkArn)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.UpdateFrameworkResponse.ReadOnly =
    zio.aws.backup.model.UpdateFrameworkResponse.wrap(buildAwsValue())
}
object UpdateFrameworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.UpdateFrameworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.UpdateFrameworkResponse =
      zio.aws.backup.model.UpdateFrameworkResponse(
        frameworkName.map(value => value),
        frameworkArn.map(value => value),
        creationTime.map(value => value)
      )
    def frameworkName: Optional[FrameworkName]
    def frameworkArn: Optional[ARN]
    def creationTime: Optional[Timestamp]
    def getFrameworkName: ZIO[Any, AwsError, FrameworkName] =
      AwsError.unwrapOptionField("frameworkName", frameworkName)
    def getFrameworkArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("frameworkArn", frameworkArn)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.UpdateFrameworkResponse
  ) extends zio.aws.backup.model.UpdateFrameworkResponse.ReadOnly {
    override val frameworkName: Optional[FrameworkName] = zio.aws.core.internal
      .optionalFromNullable(impl.frameworkName())
      .map(value => zio.aws.backup.model.primitives.FrameworkName(value))
    override val frameworkArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.frameworkArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.UpdateFrameworkResponse
  ): zio.aws.backup.model.UpdateFrameworkResponse.ReadOnly = new Wrapper(impl)
}
