package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListLegalHoldsResponse(
    nextToken: Optional[String] = Optional.Absent,
    legalHolds: Optional[Iterable[zio.aws.backup.model.LegalHold]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListLegalHoldsResponse = {
    import ListLegalHoldsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListLegalHoldsResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        legalHolds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.legalHolds)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListLegalHoldsResponse.ReadOnly =
    zio.aws.backup.model.ListLegalHoldsResponse.wrap(buildAwsValue())
}
object ListLegalHoldsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListLegalHoldsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListLegalHoldsResponse =
      zio.aws.backup.model.ListLegalHoldsResponse(
        nextToken.map(value => value),
        legalHolds.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def legalHolds: Optional[List[zio.aws.backup.model.LegalHold.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLegalHolds
        : ZIO[Any, AwsError, List[zio.aws.backup.model.LegalHold.ReadOnly]] =
      AwsError.unwrapOptionField("legalHolds", legalHolds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListLegalHoldsResponse
  ) extends zio.aws.backup.model.ListLegalHoldsResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val legalHolds
        : Optional[List[zio.aws.backup.model.LegalHold.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.legalHolds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.backup.model.LegalHold.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListLegalHoldsResponse
  ): zio.aws.backup.model.ListLegalHoldsResponse.ReadOnly = new Wrapper(impl)
}
