package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetLegalHoldRequest(legalHoldId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.GetLegalHoldRequest = {
    import GetLegalHoldRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.GetLegalHoldRequest
      .builder()
      .legalHoldId(legalHoldId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.GetLegalHoldRequest.ReadOnly =
    zio.aws.backup.model.GetLegalHoldRequest.wrap(buildAwsValue())
}
object GetLegalHoldRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.GetLegalHoldRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.GetLegalHoldRequest =
      zio.aws.backup.model.GetLegalHoldRequest(legalHoldId)
    def legalHoldId: String
    def getLegalHoldId: ZIO[Any, Nothing, String] = ZIO.succeed(legalHoldId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.GetLegalHoldRequest
  ) extends zio.aws.backup.model.GetLegalHoldRequest.ReadOnly {
    override val legalHoldId: String = impl.legalHoldId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.GetLegalHoldRequest
  ): zio.aws.backup.model.GetLegalHoldRequest.ReadOnly = new Wrapper(impl)
}
