package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{IAMPolicy, ARN, BackupVaultName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetBackupVaultAccessPolicyResponse(
    backupVaultName: Optional[BackupVaultName] = Optional.Absent,
    backupVaultArn: Optional[ARN] = Optional.Absent,
    policy: Optional[IAMPolicy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyResponse = {
    import GetBackupVaultAccessPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyResponse
      .builder()
      .optionallyWith(
        backupVaultName.map(value =>
          BackupVaultName.unwrap(value): java.lang.String
        )
      )(_.backupVaultName)
      .optionallyWith(
        backupVaultArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.backupVaultArn)
      .optionallyWith(
        policy.map(value => IAMPolicy.unwrap(value): java.lang.String)
      )(_.policy)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.GetBackupVaultAccessPolicyResponse.ReadOnly =
    zio.aws.backup.model.GetBackupVaultAccessPolicyResponse
      .wrap(buildAwsValue())
}
object GetBackupVaultAccessPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.GetBackupVaultAccessPolicyResponse =
      zio.aws.backup.model.GetBackupVaultAccessPolicyResponse(
        backupVaultName.map(value => value),
        backupVaultArn.map(value => value),
        policy.map(value => value)
      )
    def backupVaultName: Optional[BackupVaultName]
    def backupVaultArn: Optional[ARN]
    def policy: Optional[IAMPolicy]
    def getBackupVaultName: ZIO[Any, AwsError, BackupVaultName] =
      AwsError.unwrapOptionField("backupVaultName", backupVaultName)
    def getBackupVaultArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("backupVaultArn", backupVaultArn)
    def getPolicy: ZIO[Any, AwsError, IAMPolicy] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyResponse
  ) extends zio.aws.backup.model.GetBackupVaultAccessPolicyResponse.ReadOnly {
    override val backupVaultName: Optional[BackupVaultName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupVaultName())
        .map(value => zio.aws.backup.model.primitives.BackupVaultName(value))
    override val backupVaultArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.backupVaultArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val policy: Optional[IAMPolicy] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => zio.aws.backup.model.primitives.IAMPolicy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyResponse
  ): zio.aws.backup.model.GetBackupVaultAccessPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
