package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{Timestamp, ARN, ReportPlanName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class UpdateReportPlanResponse(
    reportPlanName: Optional[ReportPlanName] = Optional.Absent,
    reportPlanArn: Optional[ARN] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.UpdateReportPlanResponse = {
    import UpdateReportPlanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.UpdateReportPlanResponse
      .builder()
      .optionallyWith(
        reportPlanName.map(value =>
          ReportPlanName.unwrap(value): java.lang.String
        )
      )(_.reportPlanName)
      .optionallyWith(
        reportPlanArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.reportPlanArn)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.UpdateReportPlanResponse.ReadOnly =
    zio.aws.backup.model.UpdateReportPlanResponse.wrap(buildAwsValue())
}
object UpdateReportPlanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.UpdateReportPlanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.UpdateReportPlanResponse =
      zio.aws.backup.model.UpdateReportPlanResponse(
        reportPlanName.map(value => value),
        reportPlanArn.map(value => value),
        creationTime.map(value => value)
      )
    def reportPlanName: Optional[ReportPlanName]
    def reportPlanArn: Optional[ARN]
    def creationTime: Optional[Timestamp]
    def getReportPlanName: ZIO[Any, AwsError, ReportPlanName] =
      AwsError.unwrapOptionField("reportPlanName", reportPlanName)
    def getReportPlanArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("reportPlanArn", reportPlanArn)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.UpdateReportPlanResponse
  ) extends zio.aws.backup.model.UpdateReportPlanResponse.ReadOnly {
    override val reportPlanName: Optional[ReportPlanName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reportPlanName())
        .map(value => zio.aws.backup.model.primitives.ReportPlanName(value))
    override val reportPlanArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.reportPlanArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.UpdateReportPlanResponse
  ): zio.aws.backup.model.UpdateReportPlanResponse.ReadOnly = new Wrapper(impl)
}
