package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{
  Timestamp,
  ReportPlanDescription,
  ReportPlanName,
  ARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ReportPlan(
    reportPlanArn: Optional[ARN] = Optional.Absent,
    reportPlanName: Optional[ReportPlanName] = Optional.Absent,
    reportPlanDescription: Optional[ReportPlanDescription] = Optional.Absent,
    reportSetting: Optional[zio.aws.backup.model.ReportSetting] =
      Optional.Absent,
    reportDeliveryChannel: Optional[
      zio.aws.backup.model.ReportDeliveryChannel
    ] = Optional.Absent,
    deploymentStatus: Optional[String] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastAttemptedExecutionTime: Optional[Timestamp] = Optional.Absent,
    lastSuccessfulExecutionTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ReportPlan = {
    import ReportPlan.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ReportPlan
      .builder()
      .optionallyWith(
        reportPlanArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.reportPlanArn)
      .optionallyWith(
        reportPlanName.map(value =>
          ReportPlanName.unwrap(value): java.lang.String
        )
      )(_.reportPlanName)
      .optionallyWith(
        reportPlanDescription.map(value =>
          ReportPlanDescription.unwrap(value): java.lang.String
        )
      )(_.reportPlanDescription)
      .optionallyWith(reportSetting.map(value => value.buildAwsValue()))(
        _.reportSetting
      )
      .optionallyWith(
        reportDeliveryChannel.map(value => value.buildAwsValue())
      )(_.reportDeliveryChannel)
      .optionallyWith(deploymentStatus.map(value => value: java.lang.String))(
        _.deploymentStatus
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastAttemptedExecutionTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.lastAttemptedExecutionTime)
      .optionallyWith(
        lastSuccessfulExecutionTime.map(value =>
          Timestamp.unwrap(value): Instant
        )
      )(_.lastSuccessfulExecutionTime)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ReportPlan.ReadOnly =
    zio.aws.backup.model.ReportPlan.wrap(buildAwsValue())
}
object ReportPlan {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.backup.model.ReportPlan] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ReportPlan =
      zio.aws.backup.model.ReportPlan(
        reportPlanArn.map(value => value),
        reportPlanName.map(value => value),
        reportPlanDescription.map(value => value),
        reportSetting.map(value => value.asEditable),
        reportDeliveryChannel.map(value => value.asEditable),
        deploymentStatus.map(value => value),
        creationTime.map(value => value),
        lastAttemptedExecutionTime.map(value => value),
        lastSuccessfulExecutionTime.map(value => value)
      )
    def reportPlanArn: Optional[ARN]
    def reportPlanName: Optional[ReportPlanName]
    def reportPlanDescription: Optional[ReportPlanDescription]
    def reportSetting: Optional[zio.aws.backup.model.ReportSetting.ReadOnly]
    def reportDeliveryChannel
        : Optional[zio.aws.backup.model.ReportDeliveryChannel.ReadOnly]
    def deploymentStatus: Optional[String]
    def creationTime: Optional[Timestamp]
    def lastAttemptedExecutionTime: Optional[Timestamp]
    def lastSuccessfulExecutionTime: Optional[Timestamp]
    def getReportPlanArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("reportPlanArn", reportPlanArn)
    def getReportPlanName: ZIO[Any, AwsError, ReportPlanName] =
      AwsError.unwrapOptionField("reportPlanName", reportPlanName)
    def getReportPlanDescription: ZIO[Any, AwsError, ReportPlanDescription] =
      AwsError.unwrapOptionField("reportPlanDescription", reportPlanDescription)
    def getReportSetting
        : ZIO[Any, AwsError, zio.aws.backup.model.ReportSetting.ReadOnly] =
      AwsError.unwrapOptionField("reportSetting", reportSetting)
    def getReportDeliveryChannel: ZIO[
      Any,
      AwsError,
      zio.aws.backup.model.ReportDeliveryChannel.ReadOnly
    ] =
      AwsError.unwrapOptionField("reportDeliveryChannel", reportDeliveryChannel)
    def getDeploymentStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deploymentStatus", deploymentStatus)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastAttemptedExecutionTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "lastAttemptedExecutionTime",
        lastAttemptedExecutionTime
      )
    def getLastSuccessfulExecutionTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField(
        "lastSuccessfulExecutionTime",
        lastSuccessfulExecutionTime
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ReportPlan
  ) extends zio.aws.backup.model.ReportPlan.ReadOnly {
    override val reportPlanArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.reportPlanArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val reportPlanName: Optional[ReportPlanName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reportPlanName())
        .map(value => zio.aws.backup.model.primitives.ReportPlanName(value))
    override val reportPlanDescription: Optional[ReportPlanDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reportPlanDescription())
        .map(value =>
          zio.aws.backup.model.primitives.ReportPlanDescription(value)
        )
    override val reportSetting
        : Optional[zio.aws.backup.model.ReportSetting.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reportSetting())
        .map(value => zio.aws.backup.model.ReportSetting.wrap(value))
    override val reportDeliveryChannel
        : Optional[zio.aws.backup.model.ReportDeliveryChannel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reportDeliveryChannel())
        .map(value => zio.aws.backup.model.ReportDeliveryChannel.wrap(value))
    override val deploymentStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentStatus())
      .map(value => value: String)
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val lastAttemptedExecutionTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastAttemptedExecutionTime())
        .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val lastSuccessfulExecutionTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSuccessfulExecutionTime())
        .map(value => zio.aws.backup.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ReportPlan
  ): zio.aws.backup.model.ReportPlan.ReadOnly = new Wrapper(impl)
}
