package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{BackupVaultName, ResourceType, ARN}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RecoveryPointMember(
    recoveryPointArn: Optional[ARN] = Optional.Absent,
    resourceArn: Optional[ARN] = Optional.Absent,
    resourceType: Optional[ResourceType] = Optional.Absent,
    backupVaultName: Optional[BackupVaultName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.RecoveryPointMember = {
    import RecoveryPointMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.RecoveryPointMember
      .builder()
      .optionallyWith(
        recoveryPointArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.recoveryPointArn)
      .optionallyWith(
        resourceArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .optionallyWith(
        backupVaultName.map(value =>
          BackupVaultName.unwrap(value): java.lang.String
        )
      )(_.backupVaultName)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.RecoveryPointMember.ReadOnly =
    zio.aws.backup.model.RecoveryPointMember.wrap(buildAwsValue())
}
object RecoveryPointMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.RecoveryPointMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.RecoveryPointMember =
      zio.aws.backup.model.RecoveryPointMember(
        recoveryPointArn.map(value => value),
        resourceArn.map(value => value),
        resourceType.map(value => value),
        backupVaultName.map(value => value)
      )
    def recoveryPointArn: Optional[ARN]
    def resourceArn: Optional[ARN]
    def resourceType: Optional[ResourceType]
    def backupVaultName: Optional[BackupVaultName]
    def getRecoveryPointArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("recoveryPointArn", recoveryPointArn)
    def getResourceArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getBackupVaultName: ZIO[Any, AwsError, BackupVaultName] =
      AwsError.unwrapOptionField("backupVaultName", backupVaultName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.RecoveryPointMember
  ) extends zio.aws.backup.model.RecoveryPointMember.ReadOnly {
    override val recoveryPointArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.recoveryPointArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val resourceArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val resourceType: Optional[ResourceType] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => zio.aws.backup.model.primitives.ResourceType(value))
    override val backupVaultName: Optional[BackupVaultName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupVaultName())
        .map(value => zio.aws.backup.model.primitives.BackupVaultName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.RecoveryPointMember
  ): zio.aws.backup.model.RecoveryPointMember.ReadOnly = new Wrapper(impl)
}
