package zio.aws.backup.model
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.MaxResults
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListReportPlansRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListReportPlansRequest = {
    import ListReportPlansRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListReportPlansRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ListReportPlansRequest.ReadOnly =
    zio.aws.backup.model.ListReportPlansRequest.wrap(buildAwsValue())
}
object ListReportPlansRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListReportPlansRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ListReportPlansRequest =
      zio.aws.backup.model.ListReportPlansRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[String]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListReportPlansRequest
  ) extends zio.aws.backup.model.ListReportPlansRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.backup.model.primitives.MaxResults(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListReportPlansRequest
  ): zio.aws.backup.model.ListReportPlansRequest.ReadOnly = new Wrapper(impl)
}
