package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{Timestamp, ARN}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeBackupVaultResponse(
    backupVaultName: Optional[String] = Optional.Absent,
    backupVaultArn: Optional[ARN] = Optional.Absent,
    vaultType: Optional[zio.aws.backup.model.VaultType] = Optional.Absent,
    encryptionKeyArn: Optional[ARN] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    creatorRequestId: Optional[String] = Optional.Absent,
    numberOfRecoveryPoints: Optional[Long] = Optional.Absent,
    locked: Optional[Boolean] = Optional.Absent,
    minRetentionDays: Optional[Long] = Optional.Absent,
    maxRetentionDays: Optional[Long] = Optional.Absent,
    lockDate: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.DescribeBackupVaultResponse = {
    import DescribeBackupVaultResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.DescribeBackupVaultResponse
      .builder()
      .optionallyWith(backupVaultName.map(value => value: java.lang.String))(
        _.backupVaultName
      )
      .optionallyWith(
        backupVaultArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.backupVaultArn)
      .optionallyWith(vaultType.map(value => value.unwrap))(_.vaultType)
      .optionallyWith(
        encryptionKeyArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.encryptionKeyArn)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(creatorRequestId.map(value => value: java.lang.String))(
        _.creatorRequestId
      )
      .optionallyWith(
        numberOfRecoveryPoints.map(value => value: java.lang.Long)
      )(_.numberOfRecoveryPoints)
      .optionallyWith(locked.map(value => value: java.lang.Boolean))(_.locked)
      .optionallyWith(minRetentionDays.map(value => value: java.lang.Long))(
        _.minRetentionDays
      )
      .optionallyWith(maxRetentionDays.map(value => value: java.lang.Long))(
        _.maxRetentionDays
      )
      .optionallyWith(lockDate.map(value => Timestamp.unwrap(value): Instant))(
        _.lockDate
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.DescribeBackupVaultResponse.ReadOnly =
    zio.aws.backup.model.DescribeBackupVaultResponse.wrap(buildAwsValue())
}
object DescribeBackupVaultResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.DescribeBackupVaultResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.DescribeBackupVaultResponse =
      zio.aws.backup.model.DescribeBackupVaultResponse(
        backupVaultName.map(value => value),
        backupVaultArn.map(value => value),
        vaultType.map(value => value),
        encryptionKeyArn.map(value => value),
        creationDate.map(value => value),
        creatorRequestId.map(value => value),
        numberOfRecoveryPoints.map(value => value),
        locked.map(value => value),
        minRetentionDays.map(value => value),
        maxRetentionDays.map(value => value),
        lockDate.map(value => value)
      )
    def backupVaultName: Optional[String]
    def backupVaultArn: Optional[ARN]
    def vaultType: Optional[zio.aws.backup.model.VaultType]
    def encryptionKeyArn: Optional[ARN]
    def creationDate: Optional[Timestamp]
    def creatorRequestId: Optional[String]
    def numberOfRecoveryPoints: Optional[Long]
    def locked: Optional[Boolean]
    def minRetentionDays: Optional[Long]
    def maxRetentionDays: Optional[Long]
    def lockDate: Optional[Timestamp]
    def getBackupVaultName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupVaultName", backupVaultName)
    def getBackupVaultArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("backupVaultArn", backupVaultArn)
    def getVaultType: ZIO[Any, AwsError, zio.aws.backup.model.VaultType] =
      AwsError.unwrapOptionField("vaultType", vaultType)
    def getEncryptionKeyArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("encryptionKeyArn", encryptionKeyArn)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getCreatorRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
    def getNumberOfRecoveryPoints: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("numberOfRecoveryPoints", numberOfRecoveryPoints)
    def getLocked: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("locked", locked)
    def getMinRetentionDays: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("minRetentionDays", minRetentionDays)
    def getMaxRetentionDays: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("maxRetentionDays", maxRetentionDays)
    def getLockDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lockDate", lockDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.DescribeBackupVaultResponse
  ) extends zio.aws.backup.model.DescribeBackupVaultResponse.ReadOnly {
    override val backupVaultName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.backupVaultName())
      .map(value => value: String)
    override val backupVaultArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.backupVaultArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val vaultType: Optional[zio.aws.backup.model.VaultType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vaultType())
        .map(value => zio.aws.backup.model.VaultType.wrap(value))
    override val encryptionKeyArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionKeyArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val creatorRequestId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.creatorRequestId())
      .map(value => value: String)
    override val numberOfRecoveryPoints: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfRecoveryPoints())
      .map(value => value: Long)
    override val locked: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.locked())
      .map(value => value: Boolean)
    override val minRetentionDays: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.minRetentionDays())
      .map(value => value: Long)
    override val maxRetentionDays: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRetentionDays())
      .map(value => value: Long)
    override val lockDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lockDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.DescribeBackupVaultResponse
  ): zio.aws.backup.model.DescribeBackupVaultResponse.ReadOnly = new Wrapper(
    impl
  )
}
