package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{TagValue, TagKey}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLegalHoldRequest(
    title: String,
    description: String,
    idempotencyToken: Optional[String] = Optional.Absent,
    recoveryPointSelection: Optional[
      zio.aws.backup.model.RecoveryPointSelection
    ] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.CreateLegalHoldRequest = {
    import CreateLegalHoldRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.CreateLegalHoldRequest
      .builder()
      .title(title: java.lang.String)
      .description(description: java.lang.String)
      .optionallyWith(idempotencyToken.map(value => value: java.lang.String))(
        _.idempotencyToken
      )
      .optionallyWith(
        recoveryPointSelection.map(value => value.buildAwsValue())
      )(_.recoveryPointSelection)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.CreateLegalHoldRequest.ReadOnly =
    zio.aws.backup.model.CreateLegalHoldRequest.wrap(buildAwsValue())
}
object CreateLegalHoldRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.CreateLegalHoldRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.CreateLegalHoldRequest =
      zio.aws.backup.model.CreateLegalHoldRequest(
        title,
        description,
        idempotencyToken.map(value => value),
        recoveryPointSelection.map(value => value.asEditable),
        tags.map(value => value)
      )
    def title: String
    def description: String
    def idempotencyToken: Optional[String]
    def recoveryPointSelection
        : Optional[zio.aws.backup.model.RecoveryPointSelection.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getTitle: ZIO[Any, Nothing, String] = ZIO.succeed(title)
    def getDescription: ZIO[Any, Nothing, String] = ZIO.succeed(description)
    def getIdempotencyToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
    def getRecoveryPointSelection: ZIO[
      Any,
      AwsError,
      zio.aws.backup.model.RecoveryPointSelection.ReadOnly
    ] = AwsError.unwrapOptionField(
      "recoveryPointSelection",
      recoveryPointSelection
    )
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.CreateLegalHoldRequest
  ) extends zio.aws.backup.model.CreateLegalHoldRequest.ReadOnly {
    override val title: String = impl.title(): String
    override val description: String = impl.description(): String
    override val idempotencyToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.idempotencyToken())
      .map(value => value: String)
    override val recoveryPointSelection
        : Optional[zio.aws.backup.model.RecoveryPointSelection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recoveryPointSelection())
        .map(value => zio.aws.backup.model.RecoveryPointSelection.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.backup.model.primitives
              .TagKey(key) -> zio.aws.backup.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.CreateLegalHoldRequest
  ): zio.aws.backup.model.CreateLegalHoldRequest.ReadOnly = new Wrapper(impl)
}
