package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{
  IAMRoleArn,
  AccountId,
  Timestamp,
  ResourceType,
  ARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CopyJob(
    accountId: Optional[AccountId] = Optional.Absent,
    copyJobId: Optional[String] = Optional.Absent,
    sourceBackupVaultArn: Optional[ARN] = Optional.Absent,
    sourceRecoveryPointArn: Optional[ARN] = Optional.Absent,
    destinationBackupVaultArn: Optional[ARN] = Optional.Absent,
    destinationRecoveryPointArn: Optional[ARN] = Optional.Absent,
    resourceArn: Optional[ARN] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    completionDate: Optional[Timestamp] = Optional.Absent,
    state: Optional[zio.aws.backup.model.CopyJobState] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    backupSizeInBytes: Optional[Long] = Optional.Absent,
    iamRoleArn: Optional[IAMRoleArn] = Optional.Absent,
    createdBy: Optional[zio.aws.backup.model.RecoveryPointCreator] =
      Optional.Absent,
    resourceType: Optional[ResourceType] = Optional.Absent,
    parentJobId: Optional[String] = Optional.Absent,
    isParent: Optional[Boolean] = Optional.Absent,
    compositeMemberIdentifier: Optional[String] = Optional.Absent,
    numberOfChildJobs: Optional[Long] = Optional.Absent,
    childJobsInState: Optional[Map[zio.aws.backup.model.CopyJobState, Long]] =
      Optional.Absent,
    resourceName: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.backup.model.CopyJob = {
    import CopyJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.CopyJob
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(copyJobId.map(value => value: java.lang.String))(
        _.copyJobId
      )
      .optionallyWith(
        sourceBackupVaultArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.sourceBackupVaultArn)
      .optionallyWith(
        sourceRecoveryPointArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.sourceRecoveryPointArn)
      .optionallyWith(
        destinationBackupVaultArn.map(value =>
          ARN.unwrap(value): java.lang.String
        )
      )(_.destinationBackupVaultArn)
      .optionallyWith(
        destinationRecoveryPointArn.map(value =>
          ARN.unwrap(value): java.lang.String
        )
      )(_.destinationRecoveryPointArn)
      .optionallyWith(
        resourceArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        completionDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.completionDate)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(backupSizeInBytes.map(value => value: java.lang.Long))(
        _.backupSizeInBytes
      )
      .optionallyWith(
        iamRoleArn.map(value => IAMRoleArn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .optionallyWith(parentJobId.map(value => value: java.lang.String))(
        _.parentJobId
      )
      .optionallyWith(isParent.map(value => value: java.lang.Boolean))(
        _.isParent
      )
      .optionallyWith(
        compositeMemberIdentifier.map(value => value: java.lang.String)
      )(_.compositeMemberIdentifier)
      .optionallyWith(numberOfChildJobs.map(value => value: java.lang.Long))(
        _.numberOfChildJobs
      )
      .optionallyWith(
        childJobsInState.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (value: java.lang.Long)
            })
            .asJava
        )
      )(_.childJobsInStateWithStrings)
      .optionallyWith(resourceName.map(value => value: java.lang.String))(
        _.resourceName
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.CopyJob.ReadOnly =
    zio.aws.backup.model.CopyJob.wrap(buildAwsValue())
}
object CopyJob {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.backup.model.CopyJob] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.CopyJob = zio.aws.backup.model.CopyJob(
      accountId.map(value => value),
      copyJobId.map(value => value),
      sourceBackupVaultArn.map(value => value),
      sourceRecoveryPointArn.map(value => value),
      destinationBackupVaultArn.map(value => value),
      destinationRecoveryPointArn.map(value => value),
      resourceArn.map(value => value),
      creationDate.map(value => value),
      completionDate.map(value => value),
      state.map(value => value),
      statusMessage.map(value => value),
      backupSizeInBytes.map(value => value),
      iamRoleArn.map(value => value),
      createdBy.map(value => value.asEditable),
      resourceType.map(value => value),
      parentJobId.map(value => value),
      isParent.map(value => value),
      compositeMemberIdentifier.map(value => value),
      numberOfChildJobs.map(value => value),
      childJobsInState.map(value => value),
      resourceName.map(value => value)
    )
    def accountId: Optional[AccountId]
    def copyJobId: Optional[String]
    def sourceBackupVaultArn: Optional[ARN]
    def sourceRecoveryPointArn: Optional[ARN]
    def destinationBackupVaultArn: Optional[ARN]
    def destinationRecoveryPointArn: Optional[ARN]
    def resourceArn: Optional[ARN]
    def creationDate: Optional[Timestamp]
    def completionDate: Optional[Timestamp]
    def state: Optional[zio.aws.backup.model.CopyJobState]
    def statusMessage: Optional[String]
    def backupSizeInBytes: Optional[Long]
    def iamRoleArn: Optional[IAMRoleArn]
    def createdBy: Optional[zio.aws.backup.model.RecoveryPointCreator.ReadOnly]
    def resourceType: Optional[ResourceType]
    def parentJobId: Optional[String]
    def isParent: Optional[Boolean]
    def compositeMemberIdentifier: Optional[String]
    def numberOfChildJobs: Optional[Long]
    def childJobsInState: Optional[Map[zio.aws.backup.model.CopyJobState, Long]]
    def resourceName: Optional[String]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getCopyJobId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("copyJobId", copyJobId)
    def getSourceBackupVaultArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("sourceBackupVaultArn", sourceBackupVaultArn)
    def getSourceRecoveryPointArn: ZIO[Any, AwsError, ARN] = AwsError
      .unwrapOptionField("sourceRecoveryPointArn", sourceRecoveryPointArn)
    def getDestinationBackupVaultArn: ZIO[Any, AwsError, ARN] = AwsError
      .unwrapOptionField("destinationBackupVaultArn", destinationBackupVaultArn)
    def getDestinationRecoveryPointArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField(
        "destinationRecoveryPointArn",
        destinationRecoveryPointArn
      )
    def getResourceArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getCompletionDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completionDate", completionDate)
    def getState: ZIO[Any, AwsError, zio.aws.backup.model.CopyJobState] =
      AwsError.unwrapOptionField("state", state)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getBackupSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("backupSizeInBytes", backupSizeInBytes)
    def getIamRoleArn: ZIO[Any, AwsError, IAMRoleArn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getCreatedBy: ZIO[
      Any,
      AwsError,
      zio.aws.backup.model.RecoveryPointCreator.ReadOnly
    ] = AwsError.unwrapOptionField("createdBy", createdBy)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getParentJobId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parentJobId", parentJobId)
    def getIsParent: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isParent", isParent)
    def getCompositeMemberIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("compositeMemberIdentifier", compositeMemberIdentifier)
    def getNumberOfChildJobs: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("numberOfChildJobs", numberOfChildJobs)
    def getChildJobsInState
        : ZIO[Any, AwsError, Map[zio.aws.backup.model.CopyJobState, Long]] =
      AwsError.unwrapOptionField("childJobsInState", childJobsInState)
    def getResourceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceName", resourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.CopyJob
  ) extends zio.aws.backup.model.CopyJob.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.backup.model.primitives.AccountId(value))
    override val copyJobId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.copyJobId())
      .map(value => value: String)
    override val sourceBackupVaultArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceBackupVaultArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val sourceRecoveryPointArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceRecoveryPointArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val destinationBackupVaultArn: Optional[ARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationBackupVaultArn())
        .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val destinationRecoveryPointArn: Optional[ARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationRecoveryPointArn())
        .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val resourceArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val completionDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.completionDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val state: Optional[zio.aws.backup.model.CopyJobState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.backup.model.CopyJobState.wrap(value))
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val backupSizeInBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.backupSizeInBytes())
      .map(value => value: Long)
    override val iamRoleArn: Optional[IAMRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoleArn())
      .map(value => zio.aws.backup.model.primitives.IAMRoleArn(value))
    override val createdBy
        : Optional[zio.aws.backup.model.RecoveryPointCreator.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value => zio.aws.backup.model.RecoveryPointCreator.wrap(value))
    override val resourceType: Optional[ResourceType] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => zio.aws.backup.model.primitives.ResourceType(value))
    override val parentJobId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.parentJobId())
      .map(value => value: String)
    override val isParent: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isParent())
      .map(value => value: Boolean)
    override val compositeMemberIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compositeMemberIdentifier())
        .map(value => value: String)
    override val numberOfChildJobs: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfChildJobs())
      .map(value => value: Long)
    override val childJobsInState
        : Optional[Map[zio.aws.backup.model.CopyJobState, Long]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.childJobsInState())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.backup.model.CopyJobState.wrap(key) -> (value: Long)
            })
            .toMap
        )
    override val resourceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.CopyJob
  ): zio.aws.backup.model.CopyJob.ReadOnly = new Wrapper(impl)
}
