package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetBackupPlanFromTemplateResponse(
    backupPlanDocument: Optional[zio.aws.backup.model.BackupPlan] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.GetBackupPlanFromTemplateResponse = {
    import GetBackupPlanFromTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.GetBackupPlanFromTemplateResponse
      .builder()
      .optionallyWith(backupPlanDocument.map(value => value.buildAwsValue()))(
        _.backupPlanDocument
      )
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.GetBackupPlanFromTemplateResponse.ReadOnly =
    zio.aws.backup.model.GetBackupPlanFromTemplateResponse.wrap(buildAwsValue())
}
object GetBackupPlanFromTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.GetBackupPlanFromTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.GetBackupPlanFromTemplateResponse =
      zio.aws.backup.model.GetBackupPlanFromTemplateResponse(
        backupPlanDocument.map(value => value.asEditable)
      )
    def backupPlanDocument: Optional[zio.aws.backup.model.BackupPlan.ReadOnly]
    def getBackupPlanDocument
        : ZIO[Any, AwsError, zio.aws.backup.model.BackupPlan.ReadOnly] =
      AwsError.unwrapOptionField("backupPlanDocument", backupPlanDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.GetBackupPlanFromTemplateResponse
  ) extends zio.aws.backup.model.GetBackupPlanFromTemplateResponse.ReadOnly {
    override val backupPlanDocument
        : Optional[zio.aws.backup.model.BackupPlan.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupPlanDocument())
        .map(value => zio.aws.backup.model.BackupPlan.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.GetBackupPlanFromTemplateResponse
  ): zio.aws.backup.model.GetBackupPlanFromTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
