package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.{ARN, TagValue, TagKey, BackupVaultName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateBackupVaultRequest(
    backupVaultName: BackupVaultName,
    backupVaultTags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    encryptionKeyArn: Optional[ARN] = Optional.Absent,
    creatorRequestId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.CreateBackupVaultRequest = {
    import CreateBackupVaultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.CreateBackupVaultRequest
      .builder()
      .backupVaultName(
        BackupVaultName.unwrap(backupVaultName): java.lang.String
      )
      .optionallyWith(
        backupVaultTags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.backupVaultTags)
      .optionallyWith(
        encryptionKeyArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.encryptionKeyArn)
      .optionallyWith(creatorRequestId.map(value => value: java.lang.String))(
        _.creatorRequestId
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.CreateBackupVaultRequest.ReadOnly =
    zio.aws.backup.model.CreateBackupVaultRequest.wrap(buildAwsValue())
}
object CreateBackupVaultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.CreateBackupVaultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.CreateBackupVaultRequest =
      zio.aws.backup.model.CreateBackupVaultRequest(
        backupVaultName,
        backupVaultTags.map(value => value),
        encryptionKeyArn.map(value => value),
        creatorRequestId.map(value => value)
      )
    def backupVaultName: BackupVaultName
    def backupVaultTags: Optional[Map[TagKey, TagValue]]
    def encryptionKeyArn: Optional[ARN]
    def creatorRequestId: Optional[String]
    def getBackupVaultName: ZIO[Any, Nothing, BackupVaultName] =
      ZIO.succeed(backupVaultName)
    def getBackupVaultTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("backupVaultTags", backupVaultTags)
    def getEncryptionKeyArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("encryptionKeyArn", encryptionKeyArn)
    def getCreatorRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creatorRequestId", creatorRequestId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.CreateBackupVaultRequest
  ) extends zio.aws.backup.model.CreateBackupVaultRequest.ReadOnly {
    override val backupVaultName: BackupVaultName =
      zio.aws.backup.model.primitives.BackupVaultName(impl.backupVaultName())
    override val backupVaultTags: Optional[Map[TagKey, TagValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupVaultTags())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.backup.model.primitives
                .TagKey(key) -> zio.aws.backup.model.primitives.TagValue(value)
            })
            .toMap
        )
    override val encryptionKeyArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionKeyArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val creatorRequestId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.creatorRequestId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.CreateBackupVaultRequest
  ): zio.aws.backup.model.CreateBackupVaultRequest.ReadOnly = new Wrapper(impl)
}
