package zio.aws.backup
import zio.aws.backup.model.CreateBackupSelectionResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.backup.model.primitives.{TagValue, TagKey}
import software.amazon.awssdk.services.backup.{
  BackupAsyncClientBuilder,
  BackupAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.backup.model.{
  ListBackupPlanVersionsRequest,
  ListReportJobsRequest,
  CreateBackupPlanRequest,
  UpdateRegionSettingsRequest,
  UpdateGlobalSettingsRequest,
  PutBackupVaultNotificationsRequest,
  StartBackupJobRequest,
  DescribeReportPlanRequest,
  ListRestoreJobsRequest,
  ListRecoveryPointsByBackupVaultRequest,
  CreateBackupVaultRequest,
  GetLegalHoldRequest,
  ListBackupJobsRequest,
  DeleteFrameworkRequest,
  ListLegalHoldsRequest,
  ListTagsRequest,
  DeleteBackupVaultLockConfigurationRequest,
  ListBackupPlanTemplatesRequest,
  ExportBackupPlanTemplateRequest,
  DescribeBackupVaultRequest,
  StartCopyJobRequest,
  DescribeReportJobRequest,
  DeleteBackupVaultRequest,
  DescribeRegionSettingsRequest,
  DeleteBackupPlanRequest,
  StartReportJobRequest,
  DescribeBackupJobRequest,
  ListReportPlansRequest,
  DisassociateRecoveryPointFromParentRequest,
  DescribeGlobalSettingsRequest,
  CancelLegalHoldRequest,
  ListProtectedResourcesRequest,
  CreateBackupSelectionRequest,
  GetBackupPlanFromJsonRequest,
  DeleteRecoveryPointRequest,
  StartRestoreJobRequest,
  DescribeRecoveryPointRequest,
  ListBackupPlansRequest,
  PutBackupVaultLockConfigurationRequest,
  ListBackupVaultsRequest,
  DescribeCopyJobRequest,
  CreateReportPlanRequest,
  ListCopyJobsRequest,
  DisassociateRecoveryPointRequest,
  DescribeFrameworkRequest,
  ListFrameworksRequest,
  DeleteBackupSelectionRequest,
  GetBackupPlanFromTemplateRequest,
  UpdateRecoveryPointLifecycleRequest,
  StopBackupJobRequest,
  DescribeRestoreJobRequest,
  UpdateBackupPlanRequest,
  UntagResourceRequest,
  DeleteBackupVaultAccessPolicyRequest,
  GetBackupVaultNotificationsRequest,
  UpdateReportPlanRequest,
  GetRecoveryPointRestoreMetadataRequest,
  GetBackupPlanRequest,
  GetBackupSelectionRequest,
  DeleteReportPlanRequest,
  DeleteBackupVaultNotificationsRequest,
  CreateLegalHoldRequest,
  GetBackupVaultAccessPolicyRequest,
  ListBackupSelectionsRequest,
  PutBackupVaultAccessPolicyRequest,
  UpdateFrameworkRequest,
  CreateFrameworkRequest,
  ListRecoveryPointsByLegalHoldRequest,
  TagResourceRequest,
  DescribeProtectedResourceRequest,
  ListRecoveryPointsByResourceRequest
}
import software.amazon.awssdk.services.backup.model.{
  UpdateFrameworkResponse,
  StopBackupJobResponse,
  ListBackupVaultsResponse,
  StartCopyJobResponse,
  GetSupportedResourceTypesRequest,
  ProtectedResource,
  ReportPlan,
  DeleteRecoveryPointResponse,
  GetBackupVaultNotificationsResponse,
  PutBackupVaultLockConfigurationResponse,
  ListRecoveryPointsByLegalHoldResponse,
  ListLegalHoldsResponse,
  DeleteBackupSelectionResponse,
  GetBackupPlanFromTemplateResponse,
  DeleteReportPlanResponse,
  RecoveryPointMember,
  CreateBackupVaultResponse,
  ListReportJobsResponse,
  DescribeReportJobResponse,
  StartBackupJobResponse,
  UpdateBackupPlanResponse,
  RestoreJobsListMember,
  DescribeReportPlanResponse,
  GetBackupPlanResponse,
  StartReportJobResponse,
  BackupPlansListMember,
  GetRecoveryPointRestoreMetadataResponse,
  DescribeProtectedResourceResponse,
  BackupJob,
  StartRestoreJobResponse,
  GetSupportedResourceTypesResponse,
  CreateFrameworkResponse,
  DeleteBackupVaultResponse,
  GetLegalHoldResponse,
  ListBackupPlansResponse,
  UntagResourceResponse,
  ReportJob,
  DescribeRegionSettingsResponse,
  DeleteFrameworkResponse,
  RecoveryPointByBackupVault,
  DescribeRecoveryPointResponse,
  DescribeFrameworkResponse,
  UpdateGlobalSettingsResponse,
  CreateReportPlanResponse,
  DescribeRestoreJobResponse,
  ExportBackupPlanTemplateResponse,
  ListBackupPlanVersionsResponse,
  ListBackupPlanTemplatesResponse,
  PutBackupVaultNotificationsResponse,
  DisassociateRecoveryPointFromParentResponse,
  BackupSelectionsListMember,
  DescribeCopyJobResponse,
  DisassociateRecoveryPointResponse,
  DeleteBackupVaultAccessPolicyResponse,
  DescribeBackupVaultResponse,
  UpdateRecoveryPointLifecycleResponse,
  ListRecoveryPointsByBackupVaultResponse,
  RecoveryPointByResource,
  CancelLegalHoldResponse,
  ListFrameworksResponse,
  DeleteBackupPlanResponse,
  GetBackupPlanFromJsonResponse,
  UpdateRegionSettingsResponse,
  DeleteBackupVaultLockConfigurationResponse,
  ListBackupJobsResponse,
  PutBackupVaultAccessPolicyResponse,
  ListRecoveryPointsByResourceResponse,
  CreateBackupPlanResponse,
  BackupPlanTemplatesListMember,
  CreateLegalHoldResponse,
  GetBackupSelectionResponse,
  DescribeBackupJobResponse,
  TagResourceResponse,
  BackupVaultListMember,
  ListProtectedResourcesResponse,
  LegalHold,
  ListBackupSelectionsResponse,
  CopyJob,
  DescribeGlobalSettingsResponse,
  UpdateReportPlanResponse,
  Framework,
  ListReportPlansResponse,
  GetBackupVaultAccessPolicyResponse,
  ListTagsResponse,
  ListCopyJobsResponse,
  ListRestoreJobsResponse,
  CreateBackupSelectionResponse,
  DeleteBackupVaultNotificationsResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Backup extends AspectSupport[Backup] {
  val api: BackupAsyncClient
  def getBackupVaultAccessPolicy(
      request: GetBackupVaultAccessPolicyRequest
  ): IO[
    AwsError,
    zio.aws.backup.model.GetBackupVaultAccessPolicyResponse.ReadOnly
  ]
  def describeRestoreJob(
      request: DescribeRestoreJobRequest
  ): IO[AwsError, zio.aws.backup.model.DescribeRestoreJobResponse.ReadOnly]
  def getBackupSelection(
      request: GetBackupSelectionRequest
  ): IO[AwsError, zio.aws.backup.model.GetBackupSelectionResponse.ReadOnly]
  def listRecoveryPointsByBackupVault(
      request: ListRecoveryPointsByBackupVaultRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.backup.model.RecoveryPointByBackupVault.ReadOnly
  ]
  def listRecoveryPointsByBackupVaultPaginated(
      request: ListRecoveryPointsByBackupVaultRequest
  ): IO[
    AwsError,
    zio.aws.backup.model.ListRecoveryPointsByBackupVaultResponse.ReadOnly
  ]
  def deleteReportPlan(request: DeleteReportPlanRequest): IO[AwsError, Unit]
  def listBackupPlanTemplates(request: ListBackupPlanTemplatesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.backup.model.BackupPlanTemplatesListMember.ReadOnly
  ]
  def listBackupPlanTemplatesPaginated(
      request: ListBackupPlanTemplatesRequest
  ): IO[AwsError, zio.aws.backup.model.ListBackupPlanTemplatesResponse.ReadOnly]
  def describeReportPlan(
      request: DescribeReportPlanRequest
  ): IO[AwsError, zio.aws.backup.model.DescribeReportPlanResponse.ReadOnly]
  def startReportJob(
      request: StartReportJobRequest
  ): IO[AwsError, zio.aws.backup.model.StartReportJobResponse.ReadOnly]
  def createFramework(
      request: CreateFrameworkRequest
  ): IO[AwsError, zio.aws.backup.model.CreateFrameworkResponse.ReadOnly]
  def listBackupJobs(
      request: ListBackupJobsRequest
  ): ZStream[Any, AwsError, zio.aws.backup.model.BackupJob.ReadOnly]
  def listBackupJobsPaginated(
      request: ListBackupJobsRequest
  ): IO[AwsError, zio.aws.backup.model.ListBackupJobsResponse.ReadOnly]
  def exportBackupPlanTemplate(request: ExportBackupPlanTemplateRequest): IO[
    AwsError,
    zio.aws.backup.model.ExportBackupPlanTemplateResponse.ReadOnly
  ]
  def listLegalHolds(
      request: ListLegalHoldsRequest
  ): ZStream[Any, AwsError, zio.aws.backup.model.LegalHold.ReadOnly]
  def listLegalHoldsPaginated(
      request: ListLegalHoldsRequest
  ): IO[AwsError, zio.aws.backup.model.ListLegalHoldsResponse.ReadOnly]
  def disassociateRecoveryPointFromParent(
      request: DisassociateRecoveryPointFromParentRequest
  ): IO[AwsError, Unit]
  def getRecoveryPointRestoreMetadata(
      request: GetRecoveryPointRestoreMetadataRequest
  ): IO[
    AwsError,
    zio.aws.backup.model.GetRecoveryPointRestoreMetadataResponse.ReadOnly
  ]
  def listBackupVaults(
      request: ListBackupVaultsRequest
  ): ZStream[Any, AwsError, zio.aws.backup.model.BackupVaultListMember.ReadOnly]
  def listBackupVaultsPaginated(
      request: ListBackupVaultsRequest
  ): IO[AwsError, zio.aws.backup.model.ListBackupVaultsResponse.ReadOnly]
  def listTags(
      request: ListTagsRequest
  ): ZStream[Any, AwsError, Tuple2[TagKey, TagValue]]
  def listTagsPaginated(
      request: ListTagsRequest
  ): IO[AwsError, zio.aws.backup.model.ListTagsResponse.ReadOnly]
  def getBackupVaultNotifications(
      request: GetBackupVaultNotificationsRequest
  ): IO[
    AwsError,
    zio.aws.backup.model.GetBackupVaultNotificationsResponse.ReadOnly
  ]
  def updateRegionSettings(
      request: UpdateRegionSettingsRequest
  ): IO[AwsError, Unit]
  def disassociateRecoveryPoint(
      request: DisassociateRecoveryPointRequest
  ): IO[AwsError, Unit]
  def listBackupSelections(request: ListBackupSelectionsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.backup.model.BackupSelectionsListMember.ReadOnly
  ]
  def listBackupSelectionsPaginated(
      request: ListBackupSelectionsRequest
  ): IO[AwsError, zio.aws.backup.model.ListBackupSelectionsResponse.ReadOnly]
  def updateRecoveryPointLifecycle(
      request: UpdateRecoveryPointLifecycleRequest
  ): IO[
    AwsError,
    zio.aws.backup.model.UpdateRecoveryPointLifecycleResponse.ReadOnly
  ]
  def listFrameworks(
      request: ListFrameworksRequest
  ): ZStream[Any, AwsError, zio.aws.backup.model.Framework.ReadOnly]
  def listFrameworksPaginated(
      request: ListFrameworksRequest
  ): IO[AwsError, zio.aws.backup.model.ListFrameworksResponse.ReadOnly]
  def deleteBackupVault(request: DeleteBackupVaultRequest): IO[AwsError, Unit]
  def deleteRecoveryPoint(
      request: DeleteRecoveryPointRequest
  ): IO[AwsError, Unit]
  def describeRegionSettings(
      request: DescribeRegionSettingsRequest
  ): IO[AwsError, zio.aws.backup.model.DescribeRegionSettingsResponse.ReadOnly]
  def deleteFramework(request: DeleteFrameworkRequest): IO[AwsError, Unit]
  def describeBackupVault(
      request: DescribeBackupVaultRequest
  ): IO[AwsError, zio.aws.backup.model.DescribeBackupVaultResponse.ReadOnly]
  def describeFramework(
      request: DescribeFrameworkRequest
  ): IO[AwsError, zio.aws.backup.model.DescribeFrameworkResponse.ReadOnly]
  def startCopyJob(
      request: StartCopyJobRequest
  ): IO[AwsError, zio.aws.backup.model.StartCopyJobResponse.ReadOnly]
  def deleteBackupVaultAccessPolicy(
      request: DeleteBackupVaultAccessPolicyRequest
  ): IO[AwsError, Unit]
  def putBackupVaultAccessPolicy(
      request: PutBackupVaultAccessPolicyRequest
  ): IO[AwsError, Unit]
  def createBackupVault(
      request: CreateBackupVaultRequest
  ): IO[AwsError, zio.aws.backup.model.CreateBackupVaultResponse.ReadOnly]
  def cancelLegalHold(
      request: CancelLegalHoldRequest
  ): IO[AwsError, zio.aws.backup.model.CancelLegalHoldResponse.ReadOnly]
  def listRecoveryPointsByLegalHold(
      request: ListRecoveryPointsByLegalHoldRequest
  ): ZStream[Any, AwsError, zio.aws.backup.model.RecoveryPointMember.ReadOnly]
  def listRecoveryPointsByLegalHoldPaginated(
      request: ListRecoveryPointsByLegalHoldRequest
  ): IO[
    AwsError,
    zio.aws.backup.model.ListRecoveryPointsByLegalHoldResponse.ReadOnly
  ]
  def deleteBackupSelection(
      request: DeleteBackupSelectionRequest
  ): IO[AwsError, Unit]
  def createLegalHold(
      request: CreateLegalHoldRequest
  ): IO[AwsError, zio.aws.backup.model.CreateLegalHoldResponse.ReadOnly]
  def listRecoveryPointsByResource(
      request: ListRecoveryPointsByResourceRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.backup.model.RecoveryPointByResource.ReadOnly
  ]
  def listRecoveryPointsByResourcePaginated(
      request: ListRecoveryPointsByResourceRequest
  ): IO[
    AwsError,
    zio.aws.backup.model.ListRecoveryPointsByResourceResponse.ReadOnly
  ]
  def createBackupPlan(
      request: CreateBackupPlanRequest
  ): IO[AwsError, zio.aws.backup.model.CreateBackupPlanResponse.ReadOnly]
  def deleteBackupPlan(
      request: DeleteBackupPlanRequest
  ): IO[AwsError, zio.aws.backup.model.DeleteBackupPlanResponse.ReadOnly]
  def getLegalHold(
      request: GetLegalHoldRequest
  ): IO[AwsError, zio.aws.backup.model.GetLegalHoldResponse.ReadOnly]
  def updateReportPlan(
      request: UpdateReportPlanRequest
  ): IO[AwsError, zio.aws.backup.model.UpdateReportPlanResponse.ReadOnly]
  def putBackupVaultLockConfiguration(
      request: PutBackupVaultLockConfigurationRequest
  ): IO[AwsError, Unit]
  def listRestoreJobs(
      request: ListRestoreJobsRequest
  ): ZStream[Any, AwsError, zio.aws.backup.model.RestoreJobsListMember.ReadOnly]
  def listRestoreJobsPaginated(
      request: ListRestoreJobsRequest
  ): IO[AwsError, zio.aws.backup.model.ListRestoreJobsResponse.ReadOnly]
  def untagResource(request: UntagResourceRequest): IO[AwsError, Unit]
  def listProtectedResources(
      request: ListProtectedResourcesRequest
  ): ZStream[Any, AwsError, zio.aws.backup.model.ProtectedResource.ReadOnly]
  def listProtectedResourcesPaginated(
      request: ListProtectedResourcesRequest
  ): IO[AwsError, zio.aws.backup.model.ListProtectedResourcesResponse.ReadOnly]
  def listCopyJobs(
      request: ListCopyJobsRequest
  ): ZStream[Any, AwsError, zio.aws.backup.model.CopyJob.ReadOnly]
  def listCopyJobsPaginated(
      request: ListCopyJobsRequest
  ): IO[AwsError, zio.aws.backup.model.ListCopyJobsResponse.ReadOnly]
  def listBackupPlanVersions(
      request: ListBackupPlanVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.backup.model.BackupPlansListMember.ReadOnly]
  def listBackupPlanVersionsPaginated(
      request: ListBackupPlanVersionsRequest
  ): IO[AwsError, zio.aws.backup.model.ListBackupPlanVersionsResponse.ReadOnly]
  def startRestoreJob(
      request: StartRestoreJobRequest
  ): IO[AwsError, zio.aws.backup.model.StartRestoreJobResponse.ReadOnly]
  def listReportPlans(
      request: ListReportPlansRequest
  ): ZStream[Any, AwsError, zio.aws.backup.model.ReportPlan.ReadOnly]
  def listReportPlansPaginated(
      request: ListReportPlansRequest
  ): IO[AwsError, zio.aws.backup.model.ListReportPlansResponse.ReadOnly]
  def describeBackupJob(
      request: DescribeBackupJobRequest
  ): IO[AwsError, zio.aws.backup.model.DescribeBackupJobResponse.ReadOnly]
  def getBackupPlan(
      request: GetBackupPlanRequest
  ): IO[AwsError, zio.aws.backup.model.GetBackupPlanResponse.ReadOnly]
  def describeGlobalSettings(
      request: DescribeGlobalSettingsRequest
  ): IO[AwsError, zio.aws.backup.model.DescribeGlobalSettingsResponse.ReadOnly]
  def describeCopyJob(
      request: DescribeCopyJobRequest
  ): IO[AwsError, zio.aws.backup.model.DescribeCopyJobResponse.ReadOnly]
  def deleteBackupVaultLockConfiguration(
      request: DeleteBackupVaultLockConfigurationRequest
  ): IO[AwsError, Unit]
  def listBackupPlans(
      request: ListBackupPlansRequest
  ): ZStream[Any, AwsError, zio.aws.backup.model.BackupPlansListMember.ReadOnly]
  def listBackupPlansPaginated(
      request: ListBackupPlansRequest
  ): IO[AwsError, zio.aws.backup.model.ListBackupPlansResponse.ReadOnly]
  def getSupportedResourceTypes(): IO[
    AwsError,
    zio.aws.backup.model.GetSupportedResourceTypesResponse.ReadOnly
  ]
  def tagResource(request: TagResourceRequest): IO[AwsError, Unit]
  def createReportPlan(
      request: CreateReportPlanRequest
  ): IO[AwsError, zio.aws.backup.model.CreateReportPlanResponse.ReadOnly]
  def describeRecoveryPoint(
      request: DescribeRecoveryPointRequest
  ): IO[AwsError, zio.aws.backup.model.DescribeRecoveryPointResponse.ReadOnly]
  def createBackupSelection(
      request: CreateBackupSelectionRequest
  ): IO[AwsError, ReadOnly]
  def stopBackupJob(request: StopBackupJobRequest): IO[AwsError, Unit]
  def listReportJobs(
      request: ListReportJobsRequest
  ): ZStream[Any, AwsError, zio.aws.backup.model.ReportJob.ReadOnly]
  def listReportJobsPaginated(
      request: ListReportJobsRequest
  ): IO[AwsError, zio.aws.backup.model.ListReportJobsResponse.ReadOnly]
  def startBackupJob(
      request: StartBackupJobRequest
  ): IO[AwsError, zio.aws.backup.model.StartBackupJobResponse.ReadOnly]
  def putBackupVaultNotifications(
      request: PutBackupVaultNotificationsRequest
  ): IO[AwsError, Unit]
  def describeProtectedResource(request: DescribeProtectedResourceRequest): IO[
    AwsError,
    zio.aws.backup.model.DescribeProtectedResourceResponse.ReadOnly
  ]
  def getBackupPlanFromTemplate(request: GetBackupPlanFromTemplateRequest): IO[
    AwsError,
    zio.aws.backup.model.GetBackupPlanFromTemplateResponse.ReadOnly
  ]
  def updateBackupPlan(
      request: UpdateBackupPlanRequest
  ): IO[AwsError, zio.aws.backup.model.UpdateBackupPlanResponse.ReadOnly]
  def updateGlobalSettings(
      request: UpdateGlobalSettingsRequest
  ): IO[AwsError, Unit]
  def deleteBackupVaultNotifications(
      request: DeleteBackupVaultNotificationsRequest
  ): IO[AwsError, Unit]
  def getBackupPlanFromJSON(
      request: GetBackupPlanFromJsonRequest
  ): IO[AwsError, zio.aws.backup.model.GetBackupPlanFromJsonResponse.ReadOnly]
  def updateFramework(
      request: UpdateFrameworkRequest
  ): IO[AwsError, zio.aws.backup.model.UpdateFrameworkResponse.ReadOnly]
  def describeReportJob(
      request: DescribeReportJobRequest
  ): IO[AwsError, zio.aws.backup.model.DescribeReportJobResponse.ReadOnly]
}
object Backup {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Backup] = customized(
    identity
  )
  def customized(
      customization: BackupAsyncClientBuilder => BackupAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Backup] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: BackupAsyncClientBuilder => BackupAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Backup] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = BackupAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[BackupAsyncClient, BackupAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[BackupAsyncClient, BackupAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new BackupImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class BackupImpl[R](
      override val api: BackupAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Backup
      with AwsServiceBase[R] {
    override val serviceName: String = "Backup"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): BackupImpl[R1] = new BackupImpl(api, newAspect, r)
    def getBackupVaultAccessPolicy(
        request: GetBackupVaultAccessPolicyRequest
    ): IO[
      AwsError,
      zio.aws.backup.model.GetBackupVaultAccessPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.GetBackupVaultAccessPolicyRequest,
      GetBackupVaultAccessPolicyResponse
    ]("getBackupVaultAccessPolicy", api.getBackupVaultAccessPolicy)(
      request.buildAwsValue()
    ).map(zio.aws.backup.model.GetBackupVaultAccessPolicyResponse.wrap)
      .provideEnvironment(r)
    def describeRestoreJob(
        request: DescribeRestoreJobRequest
    ): IO[AwsError, zio.aws.backup.model.DescribeRestoreJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.DescribeRestoreJobRequest,
        DescribeRestoreJobResponse
      ]("describeRestoreJob", api.describeRestoreJob)(request.buildAwsValue())
        .map(zio.aws.backup.model.DescribeRestoreJobResponse.wrap)
        .provideEnvironment(r)
    def getBackupSelection(
        request: GetBackupSelectionRequest
    ): IO[AwsError, zio.aws.backup.model.GetBackupSelectionResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.GetBackupSelectionRequest,
        GetBackupSelectionResponse
      ]("getBackupSelection", api.getBackupSelection)(request.buildAwsValue())
        .map(zio.aws.backup.model.GetBackupSelectionResponse.wrap)
        .provideEnvironment(r)
    def listRecoveryPointsByBackupVault(
        request: ListRecoveryPointsByBackupVaultRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.backup.model.RecoveryPointByBackupVault.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest,
      ListRecoveryPointsByBackupVaultResponse,
      RecoveryPointByBackupVault
    ](
      "listRecoveryPointsByBackupVault",
      api.listRecoveryPointsByBackupVault,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.recoveryPoints().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.backup.model.RecoveryPointByBackupVault.wrap(item))
      .provideEnvironment(r)
    def listRecoveryPointsByBackupVaultPaginated(
        request: ListRecoveryPointsByBackupVaultRequest
    ): IO[
      AwsError,
      zio.aws.backup.model.ListRecoveryPointsByBackupVaultResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultRequest,
      ListRecoveryPointsByBackupVaultResponse
    ]("listRecoveryPointsByBackupVault", api.listRecoveryPointsByBackupVault)(
      request.buildAwsValue()
    ).map(zio.aws.backup.model.ListRecoveryPointsByBackupVaultResponse.wrap)
      .provideEnvironment(r)
    def deleteReportPlan(request: DeleteReportPlanRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.DeleteReportPlanRequest,
        DeleteReportPlanResponse
      ]("deleteReportPlan", api.deleteReportPlan)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listBackupPlanTemplates(
        request: ListBackupPlanTemplatesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.backup.model.BackupPlanTemplatesListMember.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest,
      ListBackupPlanTemplatesResponse,
      BackupPlanTemplatesListMember
    ](
      "listBackupPlanTemplates",
      api.listBackupPlanTemplates,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.backupPlanTemplatesList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.backup.model.BackupPlanTemplatesListMember.wrap(item)
      )
      .provideEnvironment(r)
    def listBackupPlanTemplatesPaginated(
        request: ListBackupPlanTemplatesRequest
    ): IO[
      AwsError,
      zio.aws.backup.model.ListBackupPlanTemplatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.ListBackupPlanTemplatesRequest,
      ListBackupPlanTemplatesResponse
    ]("listBackupPlanTemplates", api.listBackupPlanTemplates)(
      request.buildAwsValue()
    ).map(zio.aws.backup.model.ListBackupPlanTemplatesResponse.wrap)
      .provideEnvironment(r)
    def describeReportPlan(
        request: DescribeReportPlanRequest
    ): IO[AwsError, zio.aws.backup.model.DescribeReportPlanResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.DescribeReportPlanRequest,
        DescribeReportPlanResponse
      ]("describeReportPlan", api.describeReportPlan)(request.buildAwsValue())
        .map(zio.aws.backup.model.DescribeReportPlanResponse.wrap)
        .provideEnvironment(r)
    def startReportJob(
        request: StartReportJobRequest
    ): IO[AwsError, zio.aws.backup.model.StartReportJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.StartReportJobRequest,
        StartReportJobResponse
      ]("startReportJob", api.startReportJob)(request.buildAwsValue())
        .map(zio.aws.backup.model.StartReportJobResponse.wrap)
        .provideEnvironment(r)
    def createFramework(
        request: CreateFrameworkRequest
    ): IO[AwsError, zio.aws.backup.model.CreateFrameworkResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.CreateFrameworkRequest,
        CreateFrameworkResponse
      ]("createFramework", api.createFramework)(request.buildAwsValue())
        .map(zio.aws.backup.model.CreateFrameworkResponse.wrap)
        .provideEnvironment(r)
    def listBackupJobs(
        request: ListBackupJobsRequest
    ): ZStream[Any, AwsError, zio.aws.backup.model.BackupJob.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.backup.model.ListBackupJobsRequest,
        ListBackupJobsResponse,
        BackupJob
      ](
        "listBackupJobs",
        api.listBackupJobs,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.backupJobs().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.backup.model.BackupJob.wrap(item))
        .provideEnvironment(r)
    def listBackupJobsPaginated(
        request: ListBackupJobsRequest
    ): IO[AwsError, zio.aws.backup.model.ListBackupJobsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.ListBackupJobsRequest,
        ListBackupJobsResponse
      ]("listBackupJobs", api.listBackupJobs)(request.buildAwsValue())
        .map(zio.aws.backup.model.ListBackupJobsResponse.wrap)
        .provideEnvironment(r)
    def exportBackupPlanTemplate(request: ExportBackupPlanTemplateRequest): IO[
      AwsError,
      zio.aws.backup.model.ExportBackupPlanTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.ExportBackupPlanTemplateRequest,
      ExportBackupPlanTemplateResponse
    ]("exportBackupPlanTemplate", api.exportBackupPlanTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.backup.model.ExportBackupPlanTemplateResponse.wrap)
      .provideEnvironment(r)
    def listLegalHolds(
        request: ListLegalHoldsRequest
    ): ZStream[Any, AwsError, zio.aws.backup.model.LegalHold.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest,
        ListLegalHoldsResponse,
        LegalHold
      ](
        "listLegalHolds",
        api.listLegalHolds,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.legalHolds().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.backup.model.LegalHold.wrap(item))
        .provideEnvironment(r)
    def listLegalHoldsPaginated(
        request: ListLegalHoldsRequest
    ): IO[AwsError, zio.aws.backup.model.ListLegalHoldsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.ListLegalHoldsRequest,
        ListLegalHoldsResponse
      ]("listLegalHolds", api.listLegalHolds)(request.buildAwsValue())
        .map(zio.aws.backup.model.ListLegalHoldsResponse.wrap)
        .provideEnvironment(r)
    def disassociateRecoveryPointFromParent(
        request: DisassociateRecoveryPointFromParentRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointFromParentRequest,
      DisassociateRecoveryPointFromParentResponse
    ](
      "disassociateRecoveryPointFromParent",
      api.disassociateRecoveryPointFromParent
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getRecoveryPointRestoreMetadata(
        request: GetRecoveryPointRestoreMetadataRequest
    ): IO[
      AwsError,
      zio.aws.backup.model.GetRecoveryPointRestoreMetadataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.GetRecoveryPointRestoreMetadataRequest,
      GetRecoveryPointRestoreMetadataResponse
    ]("getRecoveryPointRestoreMetadata", api.getRecoveryPointRestoreMetadata)(
      request.buildAwsValue()
    ).map(zio.aws.backup.model.GetRecoveryPointRestoreMetadataResponse.wrap)
      .provideEnvironment(r)
    def listBackupVaults(request: ListBackupVaultsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.backup.model.BackupVaultListMember.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest,
      ListBackupVaultsResponse,
      BackupVaultListMember
    ](
      "listBackupVaults",
      api.listBackupVaults,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.backupVaultList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.backup.model.BackupVaultListMember.wrap(item))
      .provideEnvironment(r)
    def listBackupVaultsPaginated(
        request: ListBackupVaultsRequest
    ): IO[AwsError, zio.aws.backup.model.ListBackupVaultsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.ListBackupVaultsRequest,
        ListBackupVaultsResponse
      ]("listBackupVaults", api.listBackupVaults)(request.buildAwsValue())
        .map(zio.aws.backup.model.ListBackupVaultsResponse.wrap)
        .provideEnvironment(r)
    def listTags(
        request: ListTagsRequest
    ): ZStream[Any, AwsError, Tuple2[TagKey, TagValue]] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.backup.model.ListTagsRequest,
        ListTagsResponse,
        (java.lang.String, java.lang.String)
      ](
        "listTags",
        api.listTags,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tags().asScala)
      )(request.buildAwsValue())
        .map({ case (key, value) =>
          zio.aws.backup.model.primitives
            .TagKey(key) -> zio.aws.backup.model.primitives.TagValue(value)
        })
        .provideEnvironment(r)
    def listTagsPaginated(
        request: ListTagsRequest
    ): IO[AwsError, zio.aws.backup.model.ListTagsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.ListTagsRequest,
        ListTagsResponse
      ]("listTags", api.listTags)(request.buildAwsValue())
        .map(zio.aws.backup.model.ListTagsResponse.wrap)
        .provideEnvironment(r)
    def getBackupVaultNotifications(
        request: GetBackupVaultNotificationsRequest
    ): IO[
      AwsError,
      zio.aws.backup.model.GetBackupVaultNotificationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.GetBackupVaultNotificationsRequest,
      GetBackupVaultNotificationsResponse
    ]("getBackupVaultNotifications", api.getBackupVaultNotifications)(
      request.buildAwsValue()
    ).map(zio.aws.backup.model.GetBackupVaultNotificationsResponse.wrap)
      .provideEnvironment(r)
    def updateRegionSettings(
        request: UpdateRegionSettingsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.UpdateRegionSettingsRequest,
      UpdateRegionSettingsResponse
    ]("updateRegionSettings", api.updateRegionSettings)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def disassociateRecoveryPoint(
        request: DisassociateRecoveryPointRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.DisassociateRecoveryPointRequest,
      DisassociateRecoveryPointResponse
    ]("disassociateRecoveryPoint", api.disassociateRecoveryPoint)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listBackupSelections(request: ListBackupSelectionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.backup.model.BackupSelectionsListMember.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest,
      ListBackupSelectionsResponse,
      BackupSelectionsListMember
    ](
      "listBackupSelections",
      api.listBackupSelections,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.backupSelectionsList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.backup.model.BackupSelectionsListMember.wrap(item))
      .provideEnvironment(r)
    def listBackupSelectionsPaginated(request: ListBackupSelectionsRequest): IO[
      AwsError,
      zio.aws.backup.model.ListBackupSelectionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.ListBackupSelectionsRequest,
      ListBackupSelectionsResponse
    ]("listBackupSelections", api.listBackupSelections)(request.buildAwsValue())
      .map(zio.aws.backup.model.ListBackupSelectionsResponse.wrap)
      .provideEnvironment(r)
    def updateRecoveryPointLifecycle(
        request: UpdateRecoveryPointLifecycleRequest
    ): IO[
      AwsError,
      zio.aws.backup.model.UpdateRecoveryPointLifecycleResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.UpdateRecoveryPointLifecycleRequest,
      UpdateRecoveryPointLifecycleResponse
    ]("updateRecoveryPointLifecycle", api.updateRecoveryPointLifecycle)(
      request.buildAwsValue()
    ).map(zio.aws.backup.model.UpdateRecoveryPointLifecycleResponse.wrap)
      .provideEnvironment(r)
    def listFrameworks(
        request: ListFrameworksRequest
    ): ZStream[Any, AwsError, zio.aws.backup.model.Framework.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.backup.model.ListFrameworksRequest,
        ListFrameworksResponse,
        Framework
      ](
        "listFrameworks",
        api.listFrameworks,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.frameworks().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.backup.model.Framework.wrap(item))
        .provideEnvironment(r)
    def listFrameworksPaginated(
        request: ListFrameworksRequest
    ): IO[AwsError, zio.aws.backup.model.ListFrameworksResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.ListFrameworksRequest,
        ListFrameworksResponse
      ]("listFrameworks", api.listFrameworks)(request.buildAwsValue())
        .map(zio.aws.backup.model.ListFrameworksResponse.wrap)
        .provideEnvironment(r)
    def deleteBackupVault(
        request: DeleteBackupVaultRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.DeleteBackupVaultRequest,
      DeleteBackupVaultResponse
    ]("deleteBackupVault", api.deleteBackupVault)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def deleteRecoveryPoint(
        request: DeleteRecoveryPointRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.DeleteRecoveryPointRequest,
      DeleteRecoveryPointResponse
    ]("deleteRecoveryPoint", api.deleteRecoveryPoint)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeRegionSettings(request: DescribeRegionSettingsRequest): IO[
      AwsError,
      zio.aws.backup.model.DescribeRegionSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.DescribeRegionSettingsRequest,
      DescribeRegionSettingsResponse
    ]("describeRegionSettings", api.describeRegionSettings)(
      request.buildAwsValue()
    ).map(zio.aws.backup.model.DescribeRegionSettingsResponse.wrap)
      .provideEnvironment(r)
    def deleteFramework(request: DeleteFrameworkRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.DeleteFrameworkRequest,
        DeleteFrameworkResponse
      ]("deleteFramework", api.deleteFramework)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def describeBackupVault(
        request: DescribeBackupVaultRequest
    ): IO[AwsError, zio.aws.backup.model.DescribeBackupVaultResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.DescribeBackupVaultRequest,
        DescribeBackupVaultResponse
      ]("describeBackupVault", api.describeBackupVault)(request.buildAwsValue())
        .map(zio.aws.backup.model.DescribeBackupVaultResponse.wrap)
        .provideEnvironment(r)
    def describeFramework(
        request: DescribeFrameworkRequest
    ): IO[AwsError, zio.aws.backup.model.DescribeFrameworkResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.DescribeFrameworkRequest,
        DescribeFrameworkResponse
      ]("describeFramework", api.describeFramework)(request.buildAwsValue())
        .map(zio.aws.backup.model.DescribeFrameworkResponse.wrap)
        .provideEnvironment(r)
    def startCopyJob(
        request: StartCopyJobRequest
    ): IO[AwsError, zio.aws.backup.model.StartCopyJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.StartCopyJobRequest,
        StartCopyJobResponse
      ]("startCopyJob", api.startCopyJob)(request.buildAwsValue())
        .map(zio.aws.backup.model.StartCopyJobResponse.wrap)
        .provideEnvironment(r)
    def deleteBackupVaultAccessPolicy(
        request: DeleteBackupVaultAccessPolicyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.DeleteBackupVaultAccessPolicyRequest,
      DeleteBackupVaultAccessPolicyResponse
    ]("deleteBackupVaultAccessPolicy", api.deleteBackupVaultAccessPolicy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def putBackupVaultAccessPolicy(
        request: PutBackupVaultAccessPolicyRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.PutBackupVaultAccessPolicyRequest,
      PutBackupVaultAccessPolicyResponse
    ]("putBackupVaultAccessPolicy", api.putBackupVaultAccessPolicy)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createBackupVault(
        request: CreateBackupVaultRequest
    ): IO[AwsError, zio.aws.backup.model.CreateBackupVaultResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.CreateBackupVaultRequest,
        CreateBackupVaultResponse
      ]("createBackupVault", api.createBackupVault)(request.buildAwsValue())
        .map(zio.aws.backup.model.CreateBackupVaultResponse.wrap)
        .provideEnvironment(r)
    def cancelLegalHold(
        request: CancelLegalHoldRequest
    ): IO[AwsError, zio.aws.backup.model.CancelLegalHoldResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.CancelLegalHoldRequest,
        CancelLegalHoldResponse
      ]("cancelLegalHold", api.cancelLegalHold)(request.buildAwsValue())
        .map(zio.aws.backup.model.CancelLegalHoldResponse.wrap)
        .provideEnvironment(r)
    def listRecoveryPointsByLegalHold(
        request: ListRecoveryPointsByLegalHoldRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.backup.model.RecoveryPointMember.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldRequest,
      ListRecoveryPointsByLegalHoldResponse,
      RecoveryPointMember
    ](
      "listRecoveryPointsByLegalHold",
      api.listRecoveryPointsByLegalHold,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.recoveryPoints().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.backup.model.RecoveryPointMember.wrap(item))
      .provideEnvironment(r)
    def listRecoveryPointsByLegalHoldPaginated(
        request: ListRecoveryPointsByLegalHoldRequest
    ): IO[
      AwsError,
      zio.aws.backup.model.ListRecoveryPointsByLegalHoldResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.ListRecoveryPointsByLegalHoldRequest,
      ListRecoveryPointsByLegalHoldResponse
    ]("listRecoveryPointsByLegalHold", api.listRecoveryPointsByLegalHold)(
      request.buildAwsValue()
    ).map(zio.aws.backup.model.ListRecoveryPointsByLegalHoldResponse.wrap)
      .provideEnvironment(r)
    def deleteBackupSelection(
        request: DeleteBackupSelectionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.DeleteBackupSelectionRequest,
      DeleteBackupSelectionResponse
    ]("deleteBackupSelection", api.deleteBackupSelection)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createLegalHold(
        request: CreateLegalHoldRequest
    ): IO[AwsError, zio.aws.backup.model.CreateLegalHoldResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.CreateLegalHoldRequest,
        CreateLegalHoldResponse
      ]("createLegalHold", api.createLegalHold)(request.buildAwsValue())
        .map(zio.aws.backup.model.CreateLegalHoldResponse.wrap)
        .provideEnvironment(r)
    def listRecoveryPointsByResource(
        request: ListRecoveryPointsByResourceRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.backup.model.RecoveryPointByResource.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest,
      ListRecoveryPointsByResourceResponse,
      RecoveryPointByResource
    ](
      "listRecoveryPointsByResource",
      api.listRecoveryPointsByResource,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.recoveryPoints().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.backup.model.RecoveryPointByResource.wrap(item))
      .provideEnvironment(r)
    def listRecoveryPointsByResourcePaginated(
        request: ListRecoveryPointsByResourceRequest
    ): IO[
      AwsError,
      zio.aws.backup.model.ListRecoveryPointsByResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.ListRecoveryPointsByResourceRequest,
      ListRecoveryPointsByResourceResponse
    ]("listRecoveryPointsByResource", api.listRecoveryPointsByResource)(
      request.buildAwsValue()
    ).map(zio.aws.backup.model.ListRecoveryPointsByResourceResponse.wrap)
      .provideEnvironment(r)
    def createBackupPlan(
        request: CreateBackupPlanRequest
    ): IO[AwsError, zio.aws.backup.model.CreateBackupPlanResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.CreateBackupPlanRequest,
        CreateBackupPlanResponse
      ]("createBackupPlan", api.createBackupPlan)(request.buildAwsValue())
        .map(zio.aws.backup.model.CreateBackupPlanResponse.wrap)
        .provideEnvironment(r)
    def deleteBackupPlan(
        request: DeleteBackupPlanRequest
    ): IO[AwsError, zio.aws.backup.model.DeleteBackupPlanResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.DeleteBackupPlanRequest,
        DeleteBackupPlanResponse
      ]("deleteBackupPlan", api.deleteBackupPlan)(request.buildAwsValue())
        .map(zio.aws.backup.model.DeleteBackupPlanResponse.wrap)
        .provideEnvironment(r)
    def getLegalHold(
        request: GetLegalHoldRequest
    ): IO[AwsError, zio.aws.backup.model.GetLegalHoldResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.GetLegalHoldRequest,
        GetLegalHoldResponse
      ]("getLegalHold", api.getLegalHold)(request.buildAwsValue())
        .map(zio.aws.backup.model.GetLegalHoldResponse.wrap)
        .provideEnvironment(r)
    def updateReportPlan(
        request: UpdateReportPlanRequest
    ): IO[AwsError, zio.aws.backup.model.UpdateReportPlanResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.UpdateReportPlanRequest,
        UpdateReportPlanResponse
      ]("updateReportPlan", api.updateReportPlan)(request.buildAwsValue())
        .map(zio.aws.backup.model.UpdateReportPlanResponse.wrap)
        .provideEnvironment(r)
    def putBackupVaultLockConfiguration(
        request: PutBackupVaultLockConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.PutBackupVaultLockConfigurationRequest,
      PutBackupVaultLockConfigurationResponse
    ]("putBackupVaultLockConfiguration", api.putBackupVaultLockConfiguration)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listRestoreJobs(request: ListRestoreJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.backup.model.RestoreJobsListMember.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest,
      ListRestoreJobsResponse,
      RestoreJobsListMember
    ](
      "listRestoreJobs",
      api.listRestoreJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.restoreJobs().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.backup.model.RestoreJobsListMember.wrap(item))
      .provideEnvironment(r)
    def listRestoreJobsPaginated(
        request: ListRestoreJobsRequest
    ): IO[AwsError, zio.aws.backup.model.ListRestoreJobsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.ListRestoreJobsRequest,
        ListRestoreJobsResponse
      ]("listRestoreJobs", api.listRestoreJobs)(request.buildAwsValue())
        .map(zio.aws.backup.model.ListRestoreJobsResponse.wrap)
        .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listProtectedResources(request: ListProtectedResourcesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.backup.model.ProtectedResource.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest,
      ListProtectedResourcesResponse,
      ProtectedResource
    ](
      "listProtectedResources",
      api.listProtectedResources,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.results().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.backup.model.ProtectedResource.wrap(item))
      .provideEnvironment(r)
    def listProtectedResourcesPaginated(
        request: ListProtectedResourcesRequest
    ): IO[
      AwsError,
      zio.aws.backup.model.ListProtectedResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.ListProtectedResourcesRequest,
      ListProtectedResourcesResponse
    ]("listProtectedResources", api.listProtectedResources)(
      request.buildAwsValue()
    ).map(zio.aws.backup.model.ListProtectedResourcesResponse.wrap)
      .provideEnvironment(r)
    def listCopyJobs(
        request: ListCopyJobsRequest
    ): ZStream[Any, AwsError, zio.aws.backup.model.CopyJob.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.backup.model.ListCopyJobsRequest,
        ListCopyJobsResponse,
        CopyJob
      ](
        "listCopyJobs",
        api.listCopyJobs,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.copyJobs().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.backup.model.CopyJob.wrap(item))
        .provideEnvironment(r)
    def listCopyJobsPaginated(
        request: ListCopyJobsRequest
    ): IO[AwsError, zio.aws.backup.model.ListCopyJobsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.ListCopyJobsRequest,
        ListCopyJobsResponse
      ]("listCopyJobs", api.listCopyJobs)(request.buildAwsValue())
        .map(zio.aws.backup.model.ListCopyJobsResponse.wrap)
        .provideEnvironment(r)
    def listBackupPlanVersions(request: ListBackupPlanVersionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.backup.model.BackupPlansListMember.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest,
      ListBackupPlanVersionsResponse,
      BackupPlansListMember
    ](
      "listBackupPlanVersions",
      api.listBackupPlanVersions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.backupPlanVersionsList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.backup.model.BackupPlansListMember.wrap(item))
      .provideEnvironment(r)
    def listBackupPlanVersionsPaginated(
        request: ListBackupPlanVersionsRequest
    ): IO[
      AwsError,
      zio.aws.backup.model.ListBackupPlanVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.ListBackupPlanVersionsRequest,
      ListBackupPlanVersionsResponse
    ]("listBackupPlanVersions", api.listBackupPlanVersions)(
      request.buildAwsValue()
    ).map(zio.aws.backup.model.ListBackupPlanVersionsResponse.wrap)
      .provideEnvironment(r)
    def startRestoreJob(
        request: StartRestoreJobRequest
    ): IO[AwsError, zio.aws.backup.model.StartRestoreJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.StartRestoreJobRequest,
        StartRestoreJobResponse
      ]("startRestoreJob", api.startRestoreJob)(request.buildAwsValue())
        .map(zio.aws.backup.model.StartRestoreJobResponse.wrap)
        .provideEnvironment(r)
    def listReportPlans(
        request: ListReportPlansRequest
    ): ZStream[Any, AwsError, zio.aws.backup.model.ReportPlan.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.backup.model.ListReportPlansRequest,
        ListReportPlansResponse,
        ReportPlan
      ](
        "listReportPlans",
        api.listReportPlans,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.reportPlans().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.backup.model.ReportPlan.wrap(item))
        .provideEnvironment(r)
    def listReportPlansPaginated(
        request: ListReportPlansRequest
    ): IO[AwsError, zio.aws.backup.model.ListReportPlansResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.ListReportPlansRequest,
        ListReportPlansResponse
      ]("listReportPlans", api.listReportPlans)(request.buildAwsValue())
        .map(zio.aws.backup.model.ListReportPlansResponse.wrap)
        .provideEnvironment(r)
    def describeBackupJob(
        request: DescribeBackupJobRequest
    ): IO[AwsError, zio.aws.backup.model.DescribeBackupJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.DescribeBackupJobRequest,
        DescribeBackupJobResponse
      ]("describeBackupJob", api.describeBackupJob)(request.buildAwsValue())
        .map(zio.aws.backup.model.DescribeBackupJobResponse.wrap)
        .provideEnvironment(r)
    def getBackupPlan(
        request: GetBackupPlanRequest
    ): IO[AwsError, zio.aws.backup.model.GetBackupPlanResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.GetBackupPlanRequest,
        GetBackupPlanResponse
      ]("getBackupPlan", api.getBackupPlan)(request.buildAwsValue())
        .map(zio.aws.backup.model.GetBackupPlanResponse.wrap)
        .provideEnvironment(r)
    def describeGlobalSettings(request: DescribeGlobalSettingsRequest): IO[
      AwsError,
      zio.aws.backup.model.DescribeGlobalSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.DescribeGlobalSettingsRequest,
      DescribeGlobalSettingsResponse
    ]("describeGlobalSettings", api.describeGlobalSettings)(
      request.buildAwsValue()
    ).map(zio.aws.backup.model.DescribeGlobalSettingsResponse.wrap)
      .provideEnvironment(r)
    def describeCopyJob(
        request: DescribeCopyJobRequest
    ): IO[AwsError, zio.aws.backup.model.DescribeCopyJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.DescribeCopyJobRequest,
        DescribeCopyJobResponse
      ]("describeCopyJob", api.describeCopyJob)(request.buildAwsValue())
        .map(zio.aws.backup.model.DescribeCopyJobResponse.wrap)
        .provideEnvironment(r)
    def deleteBackupVaultLockConfiguration(
        request: DeleteBackupVaultLockConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.DeleteBackupVaultLockConfigurationRequest,
      DeleteBackupVaultLockConfigurationResponse
    ](
      "deleteBackupVaultLockConfiguration",
      api.deleteBackupVaultLockConfiguration
    )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listBackupPlans(request: ListBackupPlansRequest): ZStream[
      Any,
      AwsError,
      zio.aws.backup.model.BackupPlansListMember.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.backup.model.ListBackupPlansRequest,
      ListBackupPlansResponse,
      BackupPlansListMember
    ](
      "listBackupPlans",
      api.listBackupPlans,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.backupPlansList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.backup.model.BackupPlansListMember.wrap(item))
      .provideEnvironment(r)
    def listBackupPlansPaginated(
        request: ListBackupPlansRequest
    ): IO[AwsError, zio.aws.backup.model.ListBackupPlansResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.ListBackupPlansRequest,
        ListBackupPlansResponse
      ]("listBackupPlans", api.listBackupPlans)(request.buildAwsValue())
        .map(zio.aws.backup.model.ListBackupPlansResponse.wrap)
        .provideEnvironment(r)
    def getSupportedResourceTypes(): IO[
      AwsError,
      zio.aws.backup.model.GetSupportedResourceTypesResponse.ReadOnly
    ] = asyncRequestResponse[
      GetSupportedResourceTypesRequest,
      GetSupportedResourceTypesResponse
    ]("getSupportedResourceTypes", api.getSupportedResourceTypes)(
      GetSupportedResourceTypesRequest.builder().build()
    ).map(zio.aws.backup.model.GetSupportedResourceTypesResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def createReportPlan(
        request: CreateReportPlanRequest
    ): IO[AwsError, zio.aws.backup.model.CreateReportPlanResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.CreateReportPlanRequest,
        CreateReportPlanResponse
      ]("createReportPlan", api.createReportPlan)(request.buildAwsValue())
        .map(zio.aws.backup.model.CreateReportPlanResponse.wrap)
        .provideEnvironment(r)
    def describeRecoveryPoint(request: DescribeRecoveryPointRequest): IO[
      AwsError,
      zio.aws.backup.model.DescribeRecoveryPointResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.DescribeRecoveryPointRequest,
      DescribeRecoveryPointResponse
    ]("describeRecoveryPoint", api.describeRecoveryPoint)(
      request.buildAwsValue()
    ).map(zio.aws.backup.model.DescribeRecoveryPointResponse.wrap)
      .provideEnvironment(r)
    def createBackupSelection(
        request: CreateBackupSelectionRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.CreateBackupSelectionRequest,
      CreateBackupSelectionResponse
    ]("createBackupSelection", api.createBackupSelection)(
      request.buildAwsValue()
    ).map(zio.aws.backup.model.CreateBackupSelectionResponse.wrap)
      .provideEnvironment(r)
    def stopBackupJob(request: StopBackupJobRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.StopBackupJobRequest,
        StopBackupJobResponse
      ]("stopBackupJob", api.stopBackupJob)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def listReportJobs(
        request: ListReportJobsRequest
    ): ZStream[Any, AwsError, zio.aws.backup.model.ReportJob.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.backup.model.ListReportJobsRequest,
        ListReportJobsResponse,
        ReportJob
      ](
        "listReportJobs",
        api.listReportJobs,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.reportJobs().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.backup.model.ReportJob.wrap(item))
        .provideEnvironment(r)
    def listReportJobsPaginated(
        request: ListReportJobsRequest
    ): IO[AwsError, zio.aws.backup.model.ListReportJobsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.ListReportJobsRequest,
        ListReportJobsResponse
      ]("listReportJobs", api.listReportJobs)(request.buildAwsValue())
        .map(zio.aws.backup.model.ListReportJobsResponse.wrap)
        .provideEnvironment(r)
    def startBackupJob(
        request: StartBackupJobRequest
    ): IO[AwsError, zio.aws.backup.model.StartBackupJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.StartBackupJobRequest,
        StartBackupJobResponse
      ]("startBackupJob", api.startBackupJob)(request.buildAwsValue())
        .map(zio.aws.backup.model.StartBackupJobResponse.wrap)
        .provideEnvironment(r)
    def putBackupVaultNotifications(
        request: PutBackupVaultNotificationsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.PutBackupVaultNotificationsRequest,
      PutBackupVaultNotificationsResponse
    ]("putBackupVaultNotifications", api.putBackupVaultNotifications)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeProtectedResource(
        request: DescribeProtectedResourceRequest
    ): IO[
      AwsError,
      zio.aws.backup.model.DescribeProtectedResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.DescribeProtectedResourceRequest,
      DescribeProtectedResourceResponse
    ]("describeProtectedResource", api.describeProtectedResource)(
      request.buildAwsValue()
    ).map(zio.aws.backup.model.DescribeProtectedResourceResponse.wrap)
      .provideEnvironment(r)
    def getBackupPlanFromTemplate(
        request: GetBackupPlanFromTemplateRequest
    ): IO[
      AwsError,
      zio.aws.backup.model.GetBackupPlanFromTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.GetBackupPlanFromTemplateRequest,
      GetBackupPlanFromTemplateResponse
    ]("getBackupPlanFromTemplate", api.getBackupPlanFromTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.backup.model.GetBackupPlanFromTemplateResponse.wrap)
      .provideEnvironment(r)
    def updateBackupPlan(
        request: UpdateBackupPlanRequest
    ): IO[AwsError, zio.aws.backup.model.UpdateBackupPlanResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.UpdateBackupPlanRequest,
        UpdateBackupPlanResponse
      ]("updateBackupPlan", api.updateBackupPlan)(request.buildAwsValue())
        .map(zio.aws.backup.model.UpdateBackupPlanResponse.wrap)
        .provideEnvironment(r)
    def updateGlobalSettings(
        request: UpdateGlobalSettingsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.UpdateGlobalSettingsRequest,
      UpdateGlobalSettingsResponse
    ]("updateGlobalSettings", api.updateGlobalSettings)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteBackupVaultNotifications(
        request: DeleteBackupVaultNotificationsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.DeleteBackupVaultNotificationsRequest,
      DeleteBackupVaultNotificationsResponse
    ]("deleteBackupVaultNotifications", api.deleteBackupVaultNotifications)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getBackupPlanFromJSON(request: GetBackupPlanFromJsonRequest): IO[
      AwsError,
      zio.aws.backup.model.GetBackupPlanFromJsonResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.backup.model.GetBackupPlanFromJsonRequest,
      GetBackupPlanFromJsonResponse
    ]("getBackupPlanFromJSON", api.getBackupPlanFromJSON)(
      request.buildAwsValue()
    ).map(zio.aws.backup.model.GetBackupPlanFromJsonResponse.wrap)
      .provideEnvironment(r)
    def updateFramework(
        request: UpdateFrameworkRequest
    ): IO[AwsError, zio.aws.backup.model.UpdateFrameworkResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.UpdateFrameworkRequest,
        UpdateFrameworkResponse
      ]("updateFramework", api.updateFramework)(request.buildAwsValue())
        .map(zio.aws.backup.model.UpdateFrameworkResponse.wrap)
        .provideEnvironment(r)
    def describeReportJob(
        request: DescribeReportJobRequest
    ): IO[AwsError, zio.aws.backup.model.DescribeReportJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.backup.model.DescribeReportJobRequest,
        DescribeReportJobResponse
      ]("describeReportJob", api.describeReportJob)(request.buildAwsValue())
        .map(zio.aws.backup.model.DescribeReportJobResponse.wrap)
        .provideEnvironment(r)
  }
  def getBackupVaultAccessPolicy(
      request: GetBackupVaultAccessPolicyRequest
  ): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.GetBackupVaultAccessPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBackupVaultAccessPolicy(request))
  def describeRestoreJob(request: DescribeRestoreJobRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.DescribeRestoreJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRestoreJob(request))
  def getBackupSelection(request: GetBackupSelectionRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.GetBackupSelectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBackupSelection(request))
  def listRecoveryPointsByBackupVault(
      request: ListRecoveryPointsByBackupVaultRequest
  ): ZStream[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.RecoveryPointByBackupVault.ReadOnly
  ] = ZStream.serviceWithStream(_.listRecoveryPointsByBackupVault(request))
  def listRecoveryPointsByBackupVaultPaginated(
      request: ListRecoveryPointsByBackupVaultRequest
  ): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.ListRecoveryPointsByBackupVaultResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRecoveryPointsByBackupVaultPaginated(request))
  def deleteReportPlan(
      request: DeleteReportPlanRequest
  ): ZIO[zio.aws.backup.Backup, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteReportPlan(request))
  def listBackupPlanTemplates(request: ListBackupPlanTemplatesRequest): ZStream[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.BackupPlanTemplatesListMember.ReadOnly
  ] = ZStream.serviceWithStream(_.listBackupPlanTemplates(request))
  def listBackupPlanTemplatesPaginated(
      request: ListBackupPlanTemplatesRequest
  ): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.ListBackupPlanTemplatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBackupPlanTemplatesPaginated(request))
  def describeReportPlan(request: DescribeReportPlanRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.DescribeReportPlanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReportPlan(request))
  def startReportJob(request: StartReportJobRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.StartReportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startReportJob(request))
  def createFramework(request: CreateFrameworkRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.CreateFrameworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFramework(request))
  def listBackupJobs(request: ListBackupJobsRequest): ZStream[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.BackupJob.ReadOnly
  ] = ZStream.serviceWithStream(_.listBackupJobs(request))
  def listBackupJobsPaginated(request: ListBackupJobsRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.ListBackupJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBackupJobsPaginated(request))
  def exportBackupPlanTemplate(request: ExportBackupPlanTemplateRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.ExportBackupPlanTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportBackupPlanTemplate(request))
  def listLegalHolds(request: ListLegalHoldsRequest): ZStream[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.LegalHold.ReadOnly
  ] = ZStream.serviceWithStream(_.listLegalHolds(request))
  def listLegalHoldsPaginated(request: ListLegalHoldsRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.ListLegalHoldsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLegalHoldsPaginated(request))
  def disassociateRecoveryPointFromParent(
      request: DisassociateRecoveryPointFromParentRequest
  ): ZIO[zio.aws.backup.Backup, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disassociateRecoveryPointFromParent(request))
  def getRecoveryPointRestoreMetadata(
      request: GetRecoveryPointRestoreMetadataRequest
  ): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.GetRecoveryPointRestoreMetadataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRecoveryPointRestoreMetadata(request))
  def listBackupVaults(request: ListBackupVaultsRequest): ZStream[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.BackupVaultListMember.ReadOnly
  ] = ZStream.serviceWithStream(_.listBackupVaults(request))
  def listBackupVaultsPaginated(request: ListBackupVaultsRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.ListBackupVaultsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBackupVaultsPaginated(request))
  def listTags(
      request: ListTagsRequest
  ): ZStream[zio.aws.backup.Backup, AwsError, Tuple2[TagKey, TagValue]] =
    ZStream.serviceWithStream(_.listTags(request))
  def listTagsPaginated(request: ListTagsRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.ListTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsPaginated(request))
  def getBackupVaultNotifications(
      request: GetBackupVaultNotificationsRequest
  ): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.GetBackupVaultNotificationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBackupVaultNotifications(request))
  def updateRegionSettings(
      request: UpdateRegionSettingsRequest
  ): ZIO[zio.aws.backup.Backup, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateRegionSettings(request))
  def disassociateRecoveryPoint(
      request: DisassociateRecoveryPointRequest
  ): ZIO[zio.aws.backup.Backup, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disassociateRecoveryPoint(request))
  def listBackupSelections(request: ListBackupSelectionsRequest): ZStream[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.BackupSelectionsListMember.ReadOnly
  ] = ZStream.serviceWithStream(_.listBackupSelections(request))
  def listBackupSelectionsPaginated(request: ListBackupSelectionsRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.ListBackupSelectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBackupSelectionsPaginated(request))
  def updateRecoveryPointLifecycle(
      request: UpdateRecoveryPointLifecycleRequest
  ): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.UpdateRecoveryPointLifecycleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRecoveryPointLifecycle(request))
  def listFrameworks(request: ListFrameworksRequest): ZStream[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.Framework.ReadOnly
  ] = ZStream.serviceWithStream(_.listFrameworks(request))
  def listFrameworksPaginated(request: ListFrameworksRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.ListFrameworksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFrameworksPaginated(request))
  def deleteBackupVault(
      request: DeleteBackupVaultRequest
  ): ZIO[zio.aws.backup.Backup, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBackupVault(request))
  def deleteRecoveryPoint(
      request: DeleteRecoveryPointRequest
  ): ZIO[zio.aws.backup.Backup, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRecoveryPoint(request))
  def describeRegionSettings(request: DescribeRegionSettingsRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.DescribeRegionSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRegionSettings(request))
  def deleteFramework(
      request: DeleteFrameworkRequest
  ): ZIO[zio.aws.backup.Backup, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteFramework(request))
  def describeBackupVault(request: DescribeBackupVaultRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.DescribeBackupVaultResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeBackupVault(request))
  def describeFramework(request: DescribeFrameworkRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.DescribeFrameworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFramework(request))
  def startCopyJob(request: StartCopyJobRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.StartCopyJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startCopyJob(request))
  def deleteBackupVaultAccessPolicy(
      request: DeleteBackupVaultAccessPolicyRequest
  ): ZIO[zio.aws.backup.Backup, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBackupVaultAccessPolicy(request))
  def putBackupVaultAccessPolicy(
      request: PutBackupVaultAccessPolicyRequest
  ): ZIO[zio.aws.backup.Backup, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBackupVaultAccessPolicy(request))
  def createBackupVault(request: CreateBackupVaultRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.CreateBackupVaultResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBackupVault(request))
  def cancelLegalHold(request: CancelLegalHoldRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.CancelLegalHoldResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelLegalHold(request))
  def listRecoveryPointsByLegalHold(
      request: ListRecoveryPointsByLegalHoldRequest
  ): ZStream[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.RecoveryPointMember.ReadOnly
  ] = ZStream.serviceWithStream(_.listRecoveryPointsByLegalHold(request))
  def listRecoveryPointsByLegalHoldPaginated(
      request: ListRecoveryPointsByLegalHoldRequest
  ): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.ListRecoveryPointsByLegalHoldResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRecoveryPointsByLegalHoldPaginated(request))
  def deleteBackupSelection(
      request: DeleteBackupSelectionRequest
  ): ZIO[zio.aws.backup.Backup, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBackupSelection(request))
  def createLegalHold(request: CreateLegalHoldRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.CreateLegalHoldResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLegalHold(request))
  def listRecoveryPointsByResource(
      request: ListRecoveryPointsByResourceRequest
  ): ZStream[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.RecoveryPointByResource.ReadOnly
  ] = ZStream.serviceWithStream(_.listRecoveryPointsByResource(request))
  def listRecoveryPointsByResourcePaginated(
      request: ListRecoveryPointsByResourceRequest
  ): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.ListRecoveryPointsByResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRecoveryPointsByResourcePaginated(request))
  def createBackupPlan(request: CreateBackupPlanRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.CreateBackupPlanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createBackupPlan(request))
  def deleteBackupPlan(request: DeleteBackupPlanRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.DeleteBackupPlanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteBackupPlan(request))
  def getLegalHold(request: GetLegalHoldRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.GetLegalHoldResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLegalHold(request))
  def updateReportPlan(request: UpdateReportPlanRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.UpdateReportPlanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateReportPlan(request))
  def putBackupVaultLockConfiguration(
      request: PutBackupVaultLockConfigurationRequest
  ): ZIO[zio.aws.backup.Backup, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBackupVaultLockConfiguration(request))
  def listRestoreJobs(request: ListRestoreJobsRequest): ZStream[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.RestoreJobsListMember.ReadOnly
  ] = ZStream.serviceWithStream(_.listRestoreJobs(request))
  def listRestoreJobsPaginated(request: ListRestoreJobsRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.ListRestoreJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRestoreJobsPaginated(request))
  def untagResource(
      request: UntagResourceRequest
  ): ZIO[zio.aws.backup.Backup, AwsError, Unit] =
    ZIO.serviceWithZIO(_.untagResource(request))
  def listProtectedResources(request: ListProtectedResourcesRequest): ZStream[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.ProtectedResource.ReadOnly
  ] = ZStream.serviceWithStream(_.listProtectedResources(request))
  def listProtectedResourcesPaginated(
      request: ListProtectedResourcesRequest
  ): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.ListProtectedResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProtectedResourcesPaginated(request))
  def listCopyJobs(request: ListCopyJobsRequest): ZStream[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.CopyJob.ReadOnly
  ] = ZStream.serviceWithStream(_.listCopyJobs(request))
  def listCopyJobsPaginated(request: ListCopyJobsRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.ListCopyJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCopyJobsPaginated(request))
  def listBackupPlanVersions(request: ListBackupPlanVersionsRequest): ZStream[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.BackupPlansListMember.ReadOnly
  ] = ZStream.serviceWithStream(_.listBackupPlanVersions(request))
  def listBackupPlanVersionsPaginated(
      request: ListBackupPlanVersionsRequest
  ): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.ListBackupPlanVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBackupPlanVersionsPaginated(request))
  def startRestoreJob(request: StartRestoreJobRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.StartRestoreJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startRestoreJob(request))
  def listReportPlans(request: ListReportPlansRequest): ZStream[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.ReportPlan.ReadOnly
  ] = ZStream.serviceWithStream(_.listReportPlans(request))
  def listReportPlansPaginated(request: ListReportPlansRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.ListReportPlansResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listReportPlansPaginated(request))
  def describeBackupJob(request: DescribeBackupJobRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.DescribeBackupJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeBackupJob(request))
  def getBackupPlan(request: GetBackupPlanRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.GetBackupPlanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBackupPlan(request))
  def describeGlobalSettings(request: DescribeGlobalSettingsRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.DescribeGlobalSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeGlobalSettings(request))
  def describeCopyJob(request: DescribeCopyJobRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.DescribeCopyJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCopyJob(request))
  def deleteBackupVaultLockConfiguration(
      request: DeleteBackupVaultLockConfigurationRequest
  ): ZIO[zio.aws.backup.Backup, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBackupVaultLockConfiguration(request))
  def listBackupPlans(request: ListBackupPlansRequest): ZStream[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.BackupPlansListMember.ReadOnly
  ] = ZStream.serviceWithStream(_.listBackupPlans(request))
  def listBackupPlansPaginated(request: ListBackupPlansRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.ListBackupPlansResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listBackupPlansPaginated(request))
  def getSupportedResourceTypes(): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.GetSupportedResourceTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSupportedResourceTypes())
  def tagResource(
      request: TagResourceRequest
  ): ZIO[zio.aws.backup.Backup, AwsError, Unit] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def createReportPlan(request: CreateReportPlanRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.CreateReportPlanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createReportPlan(request))
  def describeRecoveryPoint(request: DescribeRecoveryPointRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.DescribeRecoveryPointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRecoveryPoint(request))
  def createBackupSelection(
      request: CreateBackupSelectionRequest
  ): ZIO[zio.aws.backup.Backup, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.createBackupSelection(request))
  def stopBackupJob(
      request: StopBackupJobRequest
  ): ZIO[zio.aws.backup.Backup, AwsError, Unit] =
    ZIO.serviceWithZIO(_.stopBackupJob(request))
  def listReportJobs(request: ListReportJobsRequest): ZStream[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.ReportJob.ReadOnly
  ] = ZStream.serviceWithStream(_.listReportJobs(request))
  def listReportJobsPaginated(request: ListReportJobsRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.ListReportJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listReportJobsPaginated(request))
  def startBackupJob(request: StartBackupJobRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.StartBackupJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startBackupJob(request))
  def putBackupVaultNotifications(
      request: PutBackupVaultNotificationsRequest
  ): ZIO[zio.aws.backup.Backup, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putBackupVaultNotifications(request))
  def describeProtectedResource(request: DescribeProtectedResourceRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.DescribeProtectedResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProtectedResource(request))
  def getBackupPlanFromTemplate(request: GetBackupPlanFromTemplateRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.GetBackupPlanFromTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBackupPlanFromTemplate(request))
  def updateBackupPlan(request: UpdateBackupPlanRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.UpdateBackupPlanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateBackupPlan(request))
  def updateGlobalSettings(
      request: UpdateGlobalSettingsRequest
  ): ZIO[zio.aws.backup.Backup, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateGlobalSettings(request))
  def deleteBackupVaultNotifications(
      request: DeleteBackupVaultNotificationsRequest
  ): ZIO[zio.aws.backup.Backup, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteBackupVaultNotifications(request))
  def getBackupPlanFromJSON(request: GetBackupPlanFromJsonRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.GetBackupPlanFromJsonResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getBackupPlanFromJSON(request))
  def updateFramework(request: UpdateFrameworkRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.UpdateFrameworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFramework(request))
  def describeReportJob(request: DescribeReportJobRequest): ZIO[
    zio.aws.backup.Backup,
    AwsError,
    zio.aws.backup.model.DescribeReportJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReportJob(request))
}
