package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReportDeliveryChannel(
    s3BucketName: String,
    s3KeyPrefix: Optional[String] = Optional.Absent,
    formats: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ReportDeliveryChannel = {
    import ReportDeliveryChannel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ReportDeliveryChannel
      .builder()
      .s3BucketName(s3BucketName: java.lang.String)
      .optionallyWith(s3KeyPrefix.map(value => value: java.lang.String))(
        _.s3KeyPrefix
      )
      .optionallyWith(
        formats.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.formats)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ReportDeliveryChannel.ReadOnly =
    zio.aws.backup.model.ReportDeliveryChannel.wrap(buildAwsValue())
}
object ReportDeliveryChannel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ReportDeliveryChannel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ReportDeliveryChannel =
      zio.aws.backup.model.ReportDeliveryChannel(
        s3BucketName,
        s3KeyPrefix.map(value => value),
        formats.map(value => value)
      )
    def s3BucketName: String
    def s3KeyPrefix: Optional[String]
    def formats: Optional[List[String]]
    def getS3BucketName: ZIO[Any, Nothing, String] = ZIO.succeed(s3BucketName)
    def getS3KeyPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3KeyPrefix", s3KeyPrefix)
    def getFormats: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("formats", formats)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ReportDeliveryChannel
  ) extends zio.aws.backup.model.ReportDeliveryChannel.ReadOnly {
    override val s3BucketName: String = impl.s3BucketName(): String
    override val s3KeyPrefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3KeyPrefix())
      .map(value => value: String)
    override val formats: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.formats())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ReportDeliveryChannel
  ): zio.aws.backup.model.ReportDeliveryChannel.ReadOnly = new Wrapper(impl)
}
