package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RecoveryPointSelection(
    vaultNames: Optional[Iterable[String]] = Optional.Absent,
    resourceIdentifiers: Optional[Iterable[String]] = Optional.Absent,
    dateRange: Optional[zio.aws.backup.model.DateRange] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.RecoveryPointSelection = {
    import RecoveryPointSelection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.RecoveryPointSelection
      .builder()
      .optionallyWith(
        vaultNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vaultNames)
      .optionallyWith(
        resourceIdentifiers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resourceIdentifiers)
      .optionallyWith(dateRange.map(value => value.buildAwsValue()))(
        _.dateRange
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.RecoveryPointSelection.ReadOnly =
    zio.aws.backup.model.RecoveryPointSelection.wrap(buildAwsValue())
}
object RecoveryPointSelection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.RecoveryPointSelection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.RecoveryPointSelection =
      zio.aws.backup.model.RecoveryPointSelection(
        vaultNames.map(value => value),
        resourceIdentifiers.map(value => value),
        dateRange.map(value => value.asEditable)
      )
    def vaultNames: Optional[List[String]]
    def resourceIdentifiers: Optional[List[String]]
    def dateRange: Optional[zio.aws.backup.model.DateRange.ReadOnly]
    def getVaultNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vaultNames", vaultNames)
    def getResourceIdentifiers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resourceIdentifiers", resourceIdentifiers)
    def getDateRange
        : ZIO[Any, AwsError, zio.aws.backup.model.DateRange.ReadOnly] =
      AwsError.unwrapOptionField("dateRange", dateRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.RecoveryPointSelection
  ) extends zio.aws.backup.model.RecoveryPointSelection.ReadOnly {
    override val vaultNames: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.vaultNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val resourceIdentifiers: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceIdentifiers())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val dateRange: Optional[zio.aws.backup.model.DateRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dateRange())
        .map(value => zio.aws.backup.model.DateRange.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.RecoveryPointSelection
  ): zio.aws.backup.model.RecoveryPointSelection.ReadOnly = new Wrapper(impl)
}
