package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{Timestamp, ResourceType, ARN}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ProtectedResource(
    resourceArn: Optional[ARN] = Optional.Absent,
    resourceType: Optional[ResourceType] = Optional.Absent,
    lastBackupTime: Optional[Timestamp] = Optional.Absent,
    resourceName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ProtectedResource = {
    import ProtectedResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ProtectedResource
      .builder()
      .optionallyWith(
        resourceArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .optionallyWith(
        lastBackupTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastBackupTime)
      .optionallyWith(resourceName.map(value => value: java.lang.String))(
        _.resourceName
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.ProtectedResource.ReadOnly =
    zio.aws.backup.model.ProtectedResource.wrap(buildAwsValue())
}
object ProtectedResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ProtectedResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.ProtectedResource =
      zio.aws.backup.model.ProtectedResource(
        resourceArn.map(value => value),
        resourceType.map(value => value),
        lastBackupTime.map(value => value),
        resourceName.map(value => value)
      )
    def resourceArn: Optional[ARN]
    def resourceType: Optional[ResourceType]
    def lastBackupTime: Optional[Timestamp]
    def resourceName: Optional[String]
    def getResourceArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getLastBackupTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastBackupTime", lastBackupTime)
    def getResourceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceName", resourceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ProtectedResource
  ) extends zio.aws.backup.model.ProtectedResource.ReadOnly {
    override val resourceArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val resourceType: Optional[ResourceType] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => zio.aws.backup.model.primitives.ResourceType(value))
    override val lastBackupTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastBackupTime())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val resourceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ProtectedResource
  ): zio.aws.backup.model.ProtectedResource.ReadOnly = new Wrapper(impl)
}
