package zio.aws.backup.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.backup.model.primitives.{Timestamp, ARN}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class StartBackupJobResponse(
    backupJobId: Optional[String] = Optional.Absent,
    recoveryPointArn: Optional[ARN] = Optional.Absent,
    creationDate: Optional[Timestamp] = Optional.Absent,
    isParent: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.StartBackupJobResponse = {
    import StartBackupJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.StartBackupJobResponse
      .builder()
      .optionallyWith(backupJobId.map(value => value: java.lang.String))(
        _.backupJobId
      )
      .optionallyWith(
        recoveryPointArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.recoveryPointArn)
      .optionallyWith(
        creationDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(isParent.map(value => value: java.lang.Boolean))(
        _.isParent
      )
      .build()
  }
  def asReadOnly: zio.aws.backup.model.StartBackupJobResponse.ReadOnly =
    zio.aws.backup.model.StartBackupJobResponse.wrap(buildAwsValue())
}
object StartBackupJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.StartBackupJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.StartBackupJobResponse =
      zio.aws.backup.model.StartBackupJobResponse(
        backupJobId.map(value => value),
        recoveryPointArn.map(value => value),
        creationDate.map(value => value),
        isParent.map(value => value)
      )
    def backupJobId: Optional[String]
    def recoveryPointArn: Optional[ARN]
    def creationDate: Optional[Timestamp]
    def isParent: Optional[Boolean]
    def getBackupJobId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("backupJobId", backupJobId)
    def getRecoveryPointArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("recoveryPointArn", recoveryPointArn)
    def getCreationDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getIsParent: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isParent", isParent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.StartBackupJobResponse
  ) extends zio.aws.backup.model.StartBackupJobResponse.ReadOnly {
    override val backupJobId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.backupJobId())
      .map(value => value: String)
    override val recoveryPointArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.recoveryPointArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
    override val creationDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.backup.model.primitives.Timestamp(value))
    override val isParent: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isParent())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.StartBackupJobResponse
  ): zio.aws.backup.model.StartBackupJobResponse.ReadOnly = new Wrapper(impl)
}
