package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListRecoveryPointsByBackupVaultResponse(
    nextToken: Optional[String] = Optional.Absent,
    recoveryPoints: Optional[
      Iterable[zio.aws.backup.model.RecoveryPointByBackupVault]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultResponse = {
    import ListRecoveryPointsByBackupVaultResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        recoveryPoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recoveryPoints)
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.ListRecoveryPointsByBackupVaultResponse.ReadOnly =
    zio.aws.backup.model.ListRecoveryPointsByBackupVaultResponse
      .wrap(buildAwsValue())
}
object ListRecoveryPointsByBackupVaultResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backup.model.ListRecoveryPointsByBackupVaultResponse =
      zio.aws.backup.model.ListRecoveryPointsByBackupVaultResponse(
        nextToken.map(value => value),
        recoveryPoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[String]
    def recoveryPoints: Optional[
      List[zio.aws.backup.model.RecoveryPointByBackupVault.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRecoveryPoints: ZIO[Any, AwsError, List[
      zio.aws.backup.model.RecoveryPointByBackupVault.ReadOnly
    ]] = AwsError.unwrapOptionField("recoveryPoints", recoveryPoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultResponse
  ) extends zio.aws.backup.model.ListRecoveryPointsByBackupVaultResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val recoveryPoints: Optional[
      List[zio.aws.backup.model.RecoveryPointByBackupVault.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.recoveryPoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.backup.model.RecoveryPointByBackupVault.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.ListRecoveryPointsByBackupVaultResponse
  ): zio.aws.backup.model.ListRecoveryPointsByBackupVaultResponse.ReadOnly =
    new Wrapper(impl)
}
