package zio.aws.backup
import zio.aws.backup.model.CreateBackupSelectionResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.backup.model.primitives.{TagValue, TagKey}
import software.amazon.awssdk.services.backup.BackupAsyncClient
import zio.aws.core.AwsError
import zio.aws.backup.model.{
  ListBackupPlanVersionsRequest,
  ListReportJobsRequest,
  CreateBackupPlanRequest,
  UpdateRegionSettingsRequest,
  UpdateGlobalSettingsRequest,
  PutBackupVaultNotificationsRequest,
  StartBackupJobRequest,
  DescribeReportPlanRequest,
  ListRestoreJobsRequest,
  ListRecoveryPointsByBackupVaultRequest,
  CreateBackupVaultRequest,
  GetLegalHoldRequest,
  ListBackupJobsRequest,
  DeleteFrameworkRequest,
  ListLegalHoldsRequest,
  ListTagsRequest,
  DeleteBackupVaultLockConfigurationRequest,
  ListBackupPlanTemplatesRequest,
  ExportBackupPlanTemplateRequest,
  DescribeBackupVaultRequest,
  StartCopyJobRequest,
  DescribeReportJobRequest,
  DeleteBackupVaultRequest,
  DescribeRegionSettingsRequest,
  DeleteBackupPlanRequest,
  StartReportJobRequest,
  DescribeBackupJobRequest,
  ListReportPlansRequest,
  DisassociateRecoveryPointFromParentRequest,
  DescribeGlobalSettingsRequest,
  CancelLegalHoldRequest,
  ListProtectedResourcesRequest,
  CreateBackupSelectionRequest,
  GetBackupPlanFromJsonRequest,
  DeleteRecoveryPointRequest,
  StartRestoreJobRequest,
  DescribeRecoveryPointRequest,
  ListBackupPlansRequest,
  PutBackupVaultLockConfigurationRequest,
  ListBackupVaultsRequest,
  DescribeCopyJobRequest,
  CreateReportPlanRequest,
  ListCopyJobsRequest,
  DisassociateRecoveryPointRequest,
  DescribeFrameworkRequest,
  ListFrameworksRequest,
  DeleteBackupSelectionRequest,
  GetBackupPlanFromTemplateRequest,
  UpdateRecoveryPointLifecycleRequest,
  StopBackupJobRequest,
  DescribeRestoreJobRequest,
  UpdateBackupPlanRequest,
  UntagResourceRequest,
  DeleteBackupVaultAccessPolicyRequest,
  GetBackupVaultNotificationsRequest,
  UpdateReportPlanRequest,
  GetRecoveryPointRestoreMetadataRequest,
  GetBackupPlanRequest,
  GetBackupSelectionRequest,
  DeleteReportPlanRequest,
  DeleteBackupVaultNotificationsRequest,
  CreateLegalHoldRequest,
  GetBackupVaultAccessPolicyRequest,
  ListBackupSelectionsRequest,
  PutBackupVaultAccessPolicyRequest,
  UpdateFrameworkRequest,
  CreateFrameworkRequest,
  ListRecoveryPointsByLegalHoldRequest,
  TagResourceRequest,
  DescribeProtectedResourceRequest,
  ListRecoveryPointsByResourceRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object BackupMock extends Mock[Backup] {
  object GetBackupVaultAccessPolicy
      extends Effect[
        GetBackupVaultAccessPolicyRequest,
        AwsError,
        zio.aws.backup.model.GetBackupVaultAccessPolicyResponse.ReadOnly
      ]
  object DescribeRestoreJob
      extends Effect[
        DescribeRestoreJobRequest,
        AwsError,
        zio.aws.backup.model.DescribeRestoreJobResponse.ReadOnly
      ]
  object GetBackupSelection
      extends Effect[
        GetBackupSelectionRequest,
        AwsError,
        zio.aws.backup.model.GetBackupSelectionResponse.ReadOnly
      ]
  object ListRecoveryPointsByBackupVault
      extends Stream[
        ListRecoveryPointsByBackupVaultRequest,
        AwsError,
        zio.aws.backup.model.RecoveryPointByBackupVault.ReadOnly
      ]
  object ListRecoveryPointsByBackupVaultPaginated
      extends Effect[
        ListRecoveryPointsByBackupVaultRequest,
        AwsError,
        zio.aws.backup.model.ListRecoveryPointsByBackupVaultResponse.ReadOnly
      ]
  object DeleteReportPlan
      extends Effect[DeleteReportPlanRequest, AwsError, Unit]
  object ListBackupPlanTemplates
      extends Stream[
        ListBackupPlanTemplatesRequest,
        AwsError,
        zio.aws.backup.model.BackupPlanTemplatesListMember.ReadOnly
      ]
  object ListBackupPlanTemplatesPaginated
      extends Effect[
        ListBackupPlanTemplatesRequest,
        AwsError,
        zio.aws.backup.model.ListBackupPlanTemplatesResponse.ReadOnly
      ]
  object DescribeReportPlan
      extends Effect[
        DescribeReportPlanRequest,
        AwsError,
        zio.aws.backup.model.DescribeReportPlanResponse.ReadOnly
      ]
  object StartReportJob
      extends Effect[
        StartReportJobRequest,
        AwsError,
        zio.aws.backup.model.StartReportJobResponse.ReadOnly
      ]
  object CreateFramework
      extends Effect[
        CreateFrameworkRequest,
        AwsError,
        zio.aws.backup.model.CreateFrameworkResponse.ReadOnly
      ]
  object ListBackupJobs
      extends Stream[
        ListBackupJobsRequest,
        AwsError,
        zio.aws.backup.model.BackupJob.ReadOnly
      ]
  object ListBackupJobsPaginated
      extends Effect[
        ListBackupJobsRequest,
        AwsError,
        zio.aws.backup.model.ListBackupJobsResponse.ReadOnly
      ]
  object ExportBackupPlanTemplate
      extends Effect[
        ExportBackupPlanTemplateRequest,
        AwsError,
        zio.aws.backup.model.ExportBackupPlanTemplateResponse.ReadOnly
      ]
  object ListLegalHolds
      extends Stream[
        ListLegalHoldsRequest,
        AwsError,
        zio.aws.backup.model.LegalHold.ReadOnly
      ]
  object ListLegalHoldsPaginated
      extends Effect[
        ListLegalHoldsRequest,
        AwsError,
        zio.aws.backup.model.ListLegalHoldsResponse.ReadOnly
      ]
  object DisassociateRecoveryPointFromParent
      extends Effect[DisassociateRecoveryPointFromParentRequest, AwsError, Unit]
  object GetRecoveryPointRestoreMetadata
      extends Effect[
        GetRecoveryPointRestoreMetadataRequest,
        AwsError,
        zio.aws.backup.model.GetRecoveryPointRestoreMetadataResponse.ReadOnly
      ]
  object ListBackupVaults
      extends Stream[
        ListBackupVaultsRequest,
        AwsError,
        zio.aws.backup.model.BackupVaultListMember.ReadOnly
      ]
  object ListBackupVaultsPaginated
      extends Effect[
        ListBackupVaultsRequest,
        AwsError,
        zio.aws.backup.model.ListBackupVaultsResponse.ReadOnly
      ]
  object ListTags
      extends Stream[ListTagsRequest, AwsError, Tuple2[TagKey, TagValue]]
  object ListTagsPaginated
      extends Effect[
        ListTagsRequest,
        AwsError,
        zio.aws.backup.model.ListTagsResponse.ReadOnly
      ]
  object GetBackupVaultNotifications
      extends Effect[
        GetBackupVaultNotificationsRequest,
        AwsError,
        zio.aws.backup.model.GetBackupVaultNotificationsResponse.ReadOnly
      ]
  object UpdateRegionSettings
      extends Effect[UpdateRegionSettingsRequest, AwsError, Unit]
  object DisassociateRecoveryPoint
      extends Effect[DisassociateRecoveryPointRequest, AwsError, Unit]
  object ListBackupSelections
      extends Stream[
        ListBackupSelectionsRequest,
        AwsError,
        zio.aws.backup.model.BackupSelectionsListMember.ReadOnly
      ]
  object ListBackupSelectionsPaginated
      extends Effect[
        ListBackupSelectionsRequest,
        AwsError,
        zio.aws.backup.model.ListBackupSelectionsResponse.ReadOnly
      ]
  object UpdateRecoveryPointLifecycle
      extends Effect[
        UpdateRecoveryPointLifecycleRequest,
        AwsError,
        zio.aws.backup.model.UpdateRecoveryPointLifecycleResponse.ReadOnly
      ]
  object ListFrameworks
      extends Stream[
        ListFrameworksRequest,
        AwsError,
        zio.aws.backup.model.Framework.ReadOnly
      ]
  object ListFrameworksPaginated
      extends Effect[
        ListFrameworksRequest,
        AwsError,
        zio.aws.backup.model.ListFrameworksResponse.ReadOnly
      ]
  object DeleteBackupVault
      extends Effect[DeleteBackupVaultRequest, AwsError, Unit]
  object DeleteRecoveryPoint
      extends Effect[DeleteRecoveryPointRequest, AwsError, Unit]
  object DescribeRegionSettings
      extends Effect[
        DescribeRegionSettingsRequest,
        AwsError,
        zio.aws.backup.model.DescribeRegionSettingsResponse.ReadOnly
      ]
  object DeleteFramework extends Effect[DeleteFrameworkRequest, AwsError, Unit]
  object DescribeBackupVault
      extends Effect[
        DescribeBackupVaultRequest,
        AwsError,
        zio.aws.backup.model.DescribeBackupVaultResponse.ReadOnly
      ]
  object DescribeFramework
      extends Effect[
        DescribeFrameworkRequest,
        AwsError,
        zio.aws.backup.model.DescribeFrameworkResponse.ReadOnly
      ]
  object StartCopyJob
      extends Effect[
        StartCopyJobRequest,
        AwsError,
        zio.aws.backup.model.StartCopyJobResponse.ReadOnly
      ]
  object DeleteBackupVaultAccessPolicy
      extends Effect[DeleteBackupVaultAccessPolicyRequest, AwsError, Unit]
  object PutBackupVaultAccessPolicy
      extends Effect[PutBackupVaultAccessPolicyRequest, AwsError, Unit]
  object CreateBackupVault
      extends Effect[
        CreateBackupVaultRequest,
        AwsError,
        zio.aws.backup.model.CreateBackupVaultResponse.ReadOnly
      ]
  object CancelLegalHold
      extends Effect[
        CancelLegalHoldRequest,
        AwsError,
        zio.aws.backup.model.CancelLegalHoldResponse.ReadOnly
      ]
  object ListRecoveryPointsByLegalHold
      extends Stream[
        ListRecoveryPointsByLegalHoldRequest,
        AwsError,
        zio.aws.backup.model.RecoveryPointMember.ReadOnly
      ]
  object ListRecoveryPointsByLegalHoldPaginated
      extends Effect[
        ListRecoveryPointsByLegalHoldRequest,
        AwsError,
        zio.aws.backup.model.ListRecoveryPointsByLegalHoldResponse.ReadOnly
      ]
  object DeleteBackupSelection
      extends Effect[DeleteBackupSelectionRequest, AwsError, Unit]
  object CreateLegalHold
      extends Effect[
        CreateLegalHoldRequest,
        AwsError,
        zio.aws.backup.model.CreateLegalHoldResponse.ReadOnly
      ]
  object ListRecoveryPointsByResource
      extends Stream[
        ListRecoveryPointsByResourceRequest,
        AwsError,
        zio.aws.backup.model.RecoveryPointByResource.ReadOnly
      ]
  object ListRecoveryPointsByResourcePaginated
      extends Effect[
        ListRecoveryPointsByResourceRequest,
        AwsError,
        zio.aws.backup.model.ListRecoveryPointsByResourceResponse.ReadOnly
      ]
  object CreateBackupPlan
      extends Effect[
        CreateBackupPlanRequest,
        AwsError,
        zio.aws.backup.model.CreateBackupPlanResponse.ReadOnly
      ]
  object DeleteBackupPlan
      extends Effect[
        DeleteBackupPlanRequest,
        AwsError,
        zio.aws.backup.model.DeleteBackupPlanResponse.ReadOnly
      ]
  object GetLegalHold
      extends Effect[
        GetLegalHoldRequest,
        AwsError,
        zio.aws.backup.model.GetLegalHoldResponse.ReadOnly
      ]
  object UpdateReportPlan
      extends Effect[
        UpdateReportPlanRequest,
        AwsError,
        zio.aws.backup.model.UpdateReportPlanResponse.ReadOnly
      ]
  object PutBackupVaultLockConfiguration
      extends Effect[PutBackupVaultLockConfigurationRequest, AwsError, Unit]
  object ListRestoreJobs
      extends Stream[
        ListRestoreJobsRequest,
        AwsError,
        zio.aws.backup.model.RestoreJobsListMember.ReadOnly
      ]
  object ListRestoreJobsPaginated
      extends Effect[
        ListRestoreJobsRequest,
        AwsError,
        zio.aws.backup.model.ListRestoreJobsResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object ListProtectedResources
      extends Stream[
        ListProtectedResourcesRequest,
        AwsError,
        zio.aws.backup.model.ProtectedResource.ReadOnly
      ]
  object ListProtectedResourcesPaginated
      extends Effect[
        ListProtectedResourcesRequest,
        AwsError,
        zio.aws.backup.model.ListProtectedResourcesResponse.ReadOnly
      ]
  object ListCopyJobs
      extends Stream[
        ListCopyJobsRequest,
        AwsError,
        zio.aws.backup.model.CopyJob.ReadOnly
      ]
  object ListCopyJobsPaginated
      extends Effect[
        ListCopyJobsRequest,
        AwsError,
        zio.aws.backup.model.ListCopyJobsResponse.ReadOnly
      ]
  object ListBackupPlanVersions
      extends Stream[
        ListBackupPlanVersionsRequest,
        AwsError,
        zio.aws.backup.model.BackupPlansListMember.ReadOnly
      ]
  object ListBackupPlanVersionsPaginated
      extends Effect[
        ListBackupPlanVersionsRequest,
        AwsError,
        zio.aws.backup.model.ListBackupPlanVersionsResponse.ReadOnly
      ]
  object StartRestoreJob
      extends Effect[
        StartRestoreJobRequest,
        AwsError,
        zio.aws.backup.model.StartRestoreJobResponse.ReadOnly
      ]
  object ListReportPlans
      extends Stream[
        ListReportPlansRequest,
        AwsError,
        zio.aws.backup.model.ReportPlan.ReadOnly
      ]
  object ListReportPlansPaginated
      extends Effect[
        ListReportPlansRequest,
        AwsError,
        zio.aws.backup.model.ListReportPlansResponse.ReadOnly
      ]
  object DescribeBackupJob
      extends Effect[
        DescribeBackupJobRequest,
        AwsError,
        zio.aws.backup.model.DescribeBackupJobResponse.ReadOnly
      ]
  object GetBackupPlan
      extends Effect[
        GetBackupPlanRequest,
        AwsError,
        zio.aws.backup.model.GetBackupPlanResponse.ReadOnly
      ]
  object DescribeGlobalSettings
      extends Effect[
        DescribeGlobalSettingsRequest,
        AwsError,
        zio.aws.backup.model.DescribeGlobalSettingsResponse.ReadOnly
      ]
  object DescribeCopyJob
      extends Effect[
        DescribeCopyJobRequest,
        AwsError,
        zio.aws.backup.model.DescribeCopyJobResponse.ReadOnly
      ]
  object DeleteBackupVaultLockConfiguration
      extends Effect[DeleteBackupVaultLockConfigurationRequest, AwsError, Unit]
  object ListBackupPlans
      extends Stream[
        ListBackupPlansRequest,
        AwsError,
        zio.aws.backup.model.BackupPlansListMember.ReadOnly
      ]
  object ListBackupPlansPaginated
      extends Effect[
        ListBackupPlansRequest,
        AwsError,
        zio.aws.backup.model.ListBackupPlansResponse.ReadOnly
      ]
  object GetSupportedResourceTypes
      extends Effect[
        Unit,
        AwsError,
        zio.aws.backup.model.GetSupportedResourceTypesResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object CreateReportPlan
      extends Effect[
        CreateReportPlanRequest,
        AwsError,
        zio.aws.backup.model.CreateReportPlanResponse.ReadOnly
      ]
  object DescribeRecoveryPoint
      extends Effect[
        DescribeRecoveryPointRequest,
        AwsError,
        zio.aws.backup.model.DescribeRecoveryPointResponse.ReadOnly
      ]
  object CreateBackupSelection
      extends Effect[CreateBackupSelectionRequest, AwsError, ReadOnly]
  object StopBackupJob extends Effect[StopBackupJobRequest, AwsError, Unit]
  object ListReportJobs
      extends Stream[
        ListReportJobsRequest,
        AwsError,
        zio.aws.backup.model.ReportJob.ReadOnly
      ]
  object ListReportJobsPaginated
      extends Effect[
        ListReportJobsRequest,
        AwsError,
        zio.aws.backup.model.ListReportJobsResponse.ReadOnly
      ]
  object StartBackupJob
      extends Effect[
        StartBackupJobRequest,
        AwsError,
        zio.aws.backup.model.StartBackupJobResponse.ReadOnly
      ]
  object PutBackupVaultNotifications
      extends Effect[PutBackupVaultNotificationsRequest, AwsError, Unit]
  object DescribeProtectedResource
      extends Effect[
        DescribeProtectedResourceRequest,
        AwsError,
        zio.aws.backup.model.DescribeProtectedResourceResponse.ReadOnly
      ]
  object GetBackupPlanFromTemplate
      extends Effect[
        GetBackupPlanFromTemplateRequest,
        AwsError,
        zio.aws.backup.model.GetBackupPlanFromTemplateResponse.ReadOnly
      ]
  object UpdateBackupPlan
      extends Effect[
        UpdateBackupPlanRequest,
        AwsError,
        zio.aws.backup.model.UpdateBackupPlanResponse.ReadOnly
      ]
  object UpdateGlobalSettings
      extends Effect[UpdateGlobalSettingsRequest, AwsError, Unit]
  object DeleteBackupVaultNotifications
      extends Effect[DeleteBackupVaultNotificationsRequest, AwsError, Unit]
  object GetBackupPlanFromJSON
      extends Effect[
        GetBackupPlanFromJsonRequest,
        AwsError,
        zio.aws.backup.model.GetBackupPlanFromJsonResponse.ReadOnly
      ]
  object UpdateFramework
      extends Effect[
        UpdateFrameworkRequest,
        AwsError,
        zio.aws.backup.model.UpdateFrameworkResponse.ReadOnly
      ]
  object DescribeReportJob
      extends Effect[
        DescribeReportJobRequest,
        AwsError,
        zio.aws.backup.model.DescribeReportJobResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Backup] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Backup] { rts =>
        zio.ZIO.succeed {
          new Backup {
            val api: BackupAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Backup = this
            def getBackupVaultAccessPolicy(
                request: GetBackupVaultAccessPolicyRequest
            ): IO[
              AwsError,
              zio.aws.backup.model.GetBackupVaultAccessPolicyResponse.ReadOnly
            ] = proxy(GetBackupVaultAccessPolicy, request)
            def describeRestoreJob(request: DescribeRestoreJobRequest): IO[
              AwsError,
              zio.aws.backup.model.DescribeRestoreJobResponse.ReadOnly
            ] = proxy(DescribeRestoreJob, request)
            def getBackupSelection(request: GetBackupSelectionRequest): IO[
              AwsError,
              zio.aws.backup.model.GetBackupSelectionResponse.ReadOnly
            ] = proxy(GetBackupSelection, request)
            def listRecoveryPointsByBackupVault(
                request: ListRecoveryPointsByBackupVaultRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.backup.model.RecoveryPointByBackupVault.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRecoveryPointsByBackupVault, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRecoveryPointsByBackupVaultPaginated(
                request: ListRecoveryPointsByBackupVaultRequest
            ): IO[
              AwsError,
              zio.aws.backup.model.ListRecoveryPointsByBackupVaultResponse.ReadOnly
            ] = proxy(ListRecoveryPointsByBackupVaultPaginated, request)
            def deleteReportPlan(
                request: DeleteReportPlanRequest
            ): IO[AwsError, Unit] = proxy(DeleteReportPlan, request)
            def listBackupPlanTemplates(
                request: ListBackupPlanTemplatesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.backup.model.BackupPlanTemplatesListMember.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListBackupPlanTemplates, request)
                }
                .getOrThrowFiberFailure()
            }
            def listBackupPlanTemplatesPaginated(
                request: ListBackupPlanTemplatesRequest
            ): IO[
              AwsError,
              zio.aws.backup.model.ListBackupPlanTemplatesResponse.ReadOnly
            ] = proxy(ListBackupPlanTemplatesPaginated, request)
            def describeReportPlan(request: DescribeReportPlanRequest): IO[
              AwsError,
              zio.aws.backup.model.DescribeReportPlanResponse.ReadOnly
            ] = proxy(DescribeReportPlan, request)
            def startReportJob(request: StartReportJobRequest): IO[
              AwsError,
              zio.aws.backup.model.StartReportJobResponse.ReadOnly
            ] = proxy(StartReportJob, request)
            def createFramework(request: CreateFrameworkRequest): IO[
              AwsError,
              zio.aws.backup.model.CreateFrameworkResponse.ReadOnly
            ] = proxy(CreateFramework, request)
            def listBackupJobs(
                request: ListBackupJobsRequest
            ): ZStream[Any, AwsError, zio.aws.backup.model.BackupJob.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListBackupJobs, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listBackupJobsPaginated(request: ListBackupJobsRequest): IO[
              AwsError,
              zio.aws.backup.model.ListBackupJobsResponse.ReadOnly
            ] = proxy(ListBackupJobsPaginated, request)
            def exportBackupPlanTemplate(
                request: ExportBackupPlanTemplateRequest
            ): IO[
              AwsError,
              zio.aws.backup.model.ExportBackupPlanTemplateResponse.ReadOnly
            ] = proxy(ExportBackupPlanTemplate, request)
            def listLegalHolds(
                request: ListLegalHoldsRequest
            ): ZStream[Any, AwsError, zio.aws.backup.model.LegalHold.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListLegalHolds, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listLegalHoldsPaginated(request: ListLegalHoldsRequest): IO[
              AwsError,
              zio.aws.backup.model.ListLegalHoldsResponse.ReadOnly
            ] = proxy(ListLegalHoldsPaginated, request)
            def disassociateRecoveryPointFromParent(
                request: DisassociateRecoveryPointFromParentRequest
            ): IO[AwsError, Unit] =
              proxy(DisassociateRecoveryPointFromParent, request)
            def getRecoveryPointRestoreMetadata(
                request: GetRecoveryPointRestoreMetadataRequest
            ): IO[
              AwsError,
              zio.aws.backup.model.GetRecoveryPointRestoreMetadataResponse.ReadOnly
            ] = proxy(GetRecoveryPointRestoreMetadata, request)
            def listBackupVaults(request: ListBackupVaultsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.backup.model.BackupVaultListMember.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListBackupVaults, request)
                }
                .getOrThrowFiberFailure()
            }
            def listBackupVaultsPaginated(request: ListBackupVaultsRequest): IO[
              AwsError,
              zio.aws.backup.model.ListBackupVaultsResponse.ReadOnly
            ] = proxy(ListBackupVaultsPaginated, request)
            def listTags(
                request: ListTagsRequest
            ): ZStream[Any, AwsError, Tuple2[TagKey, TagValue]] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListTags, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listTagsPaginated(
                request: ListTagsRequest
            ): IO[AwsError, zio.aws.backup.model.ListTagsResponse.ReadOnly] =
              proxy(ListTagsPaginated, request)
            def getBackupVaultNotifications(
                request: GetBackupVaultNotificationsRequest
            ): IO[
              AwsError,
              zio.aws.backup.model.GetBackupVaultNotificationsResponse.ReadOnly
            ] = proxy(GetBackupVaultNotifications, request)
            def updateRegionSettings(
                request: UpdateRegionSettingsRequest
            ): IO[AwsError, Unit] = proxy(UpdateRegionSettings, request)
            def disassociateRecoveryPoint(
                request: DisassociateRecoveryPointRequest
            ): IO[AwsError, Unit] = proxy(DisassociateRecoveryPoint, request)
            def listBackupSelections(
                request: ListBackupSelectionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.backup.model.BackupSelectionsListMember.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListBackupSelections, request)
                }
                .getOrThrowFiberFailure()
            }
            def listBackupSelectionsPaginated(
                request: ListBackupSelectionsRequest
            ): IO[
              AwsError,
              zio.aws.backup.model.ListBackupSelectionsResponse.ReadOnly
            ] = proxy(ListBackupSelectionsPaginated, request)
            def updateRecoveryPointLifecycle(
                request: UpdateRecoveryPointLifecycleRequest
            ): IO[
              AwsError,
              zio.aws.backup.model.UpdateRecoveryPointLifecycleResponse.ReadOnly
            ] = proxy(UpdateRecoveryPointLifecycle, request)
            def listFrameworks(
                request: ListFrameworksRequest
            ): ZStream[Any, AwsError, zio.aws.backup.model.Framework.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListFrameworks, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listFrameworksPaginated(request: ListFrameworksRequest): IO[
              AwsError,
              zio.aws.backup.model.ListFrameworksResponse.ReadOnly
            ] = proxy(ListFrameworksPaginated, request)
            def deleteBackupVault(
                request: DeleteBackupVaultRequest
            ): IO[AwsError, Unit] = proxy(DeleteBackupVault, request)
            def deleteRecoveryPoint(
                request: DeleteRecoveryPointRequest
            ): IO[AwsError, Unit] = proxy(DeleteRecoveryPoint, request)
            def describeRegionSettings(
                request: DescribeRegionSettingsRequest
            ): IO[
              AwsError,
              zio.aws.backup.model.DescribeRegionSettingsResponse.ReadOnly
            ] = proxy(DescribeRegionSettings, request)
            def deleteFramework(
                request: DeleteFrameworkRequest
            ): IO[AwsError, Unit] = proxy(DeleteFramework, request)
            def describeBackupVault(request: DescribeBackupVaultRequest): IO[
              AwsError,
              zio.aws.backup.model.DescribeBackupVaultResponse.ReadOnly
            ] = proxy(DescribeBackupVault, request)
            def describeFramework(request: DescribeFrameworkRequest): IO[
              AwsError,
              zio.aws.backup.model.DescribeFrameworkResponse.ReadOnly
            ] = proxy(DescribeFramework, request)
            def startCopyJob(request: StartCopyJobRequest): IO[
              AwsError,
              zio.aws.backup.model.StartCopyJobResponse.ReadOnly
            ] = proxy(StartCopyJob, request)
            def deleteBackupVaultAccessPolicy(
                request: DeleteBackupVaultAccessPolicyRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteBackupVaultAccessPolicy, request)
            def putBackupVaultAccessPolicy(
                request: PutBackupVaultAccessPolicyRequest
            ): IO[AwsError, Unit] = proxy(PutBackupVaultAccessPolicy, request)
            def createBackupVault(request: CreateBackupVaultRequest): IO[
              AwsError,
              zio.aws.backup.model.CreateBackupVaultResponse.ReadOnly
            ] = proxy(CreateBackupVault, request)
            def cancelLegalHold(request: CancelLegalHoldRequest): IO[
              AwsError,
              zio.aws.backup.model.CancelLegalHoldResponse.ReadOnly
            ] = proxy(CancelLegalHold, request)
            def listRecoveryPointsByLegalHold(
                request: ListRecoveryPointsByLegalHoldRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.backup.model.RecoveryPointMember.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRecoveryPointsByLegalHold, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRecoveryPointsByLegalHoldPaginated(
                request: ListRecoveryPointsByLegalHoldRequest
            ): IO[
              AwsError,
              zio.aws.backup.model.ListRecoveryPointsByLegalHoldResponse.ReadOnly
            ] = proxy(ListRecoveryPointsByLegalHoldPaginated, request)
            def deleteBackupSelection(
                request: DeleteBackupSelectionRequest
            ): IO[AwsError, Unit] = proxy(DeleteBackupSelection, request)
            def createLegalHold(request: CreateLegalHoldRequest): IO[
              AwsError,
              zio.aws.backup.model.CreateLegalHoldResponse.ReadOnly
            ] = proxy(CreateLegalHold, request)
            def listRecoveryPointsByResource(
                request: ListRecoveryPointsByResourceRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.backup.model.RecoveryPointByResource.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRecoveryPointsByResource, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRecoveryPointsByResourcePaginated(
                request: ListRecoveryPointsByResourceRequest
            ): IO[
              AwsError,
              zio.aws.backup.model.ListRecoveryPointsByResourceResponse.ReadOnly
            ] = proxy(ListRecoveryPointsByResourcePaginated, request)
            def createBackupPlan(request: CreateBackupPlanRequest): IO[
              AwsError,
              zio.aws.backup.model.CreateBackupPlanResponse.ReadOnly
            ] = proxy(CreateBackupPlan, request)
            def deleteBackupPlan(request: DeleteBackupPlanRequest): IO[
              AwsError,
              zio.aws.backup.model.DeleteBackupPlanResponse.ReadOnly
            ] = proxy(DeleteBackupPlan, request)
            def getLegalHold(request: GetLegalHoldRequest): IO[
              AwsError,
              zio.aws.backup.model.GetLegalHoldResponse.ReadOnly
            ] = proxy(GetLegalHold, request)
            def updateReportPlan(request: UpdateReportPlanRequest): IO[
              AwsError,
              zio.aws.backup.model.UpdateReportPlanResponse.ReadOnly
            ] = proxy(UpdateReportPlan, request)
            def putBackupVaultLockConfiguration(
                request: PutBackupVaultLockConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(PutBackupVaultLockConfiguration, request)
            def listRestoreJobs(request: ListRestoreJobsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.backup.model.RestoreJobsListMember.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListRestoreJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listRestoreJobsPaginated(request: ListRestoreJobsRequest): IO[
              AwsError,
              zio.aws.backup.model.ListRestoreJobsResponse.ReadOnly
            ] = proxy(ListRestoreJobsPaginated, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, Unit] = proxy(UntagResource, request)
            def listProtectedResources(
                request: ListProtectedResourcesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.backup.model.ProtectedResource.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListProtectedResources, request)
                }
                .getOrThrowFiberFailure()
            }
            def listProtectedResourcesPaginated(
                request: ListProtectedResourcesRequest
            ): IO[
              AwsError,
              zio.aws.backup.model.ListProtectedResourcesResponse.ReadOnly
            ] = proxy(ListProtectedResourcesPaginated, request)
            def listCopyJobs(
                request: ListCopyJobsRequest
            ): ZStream[Any, AwsError, zio.aws.backup.model.CopyJob.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListCopyJobs, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listCopyJobsPaginated(request: ListCopyJobsRequest): IO[
              AwsError,
              zio.aws.backup.model.ListCopyJobsResponse.ReadOnly
            ] = proxy(ListCopyJobsPaginated, request)
            def listBackupPlanVersions(
                request: ListBackupPlanVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.backup.model.BackupPlansListMember.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListBackupPlanVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listBackupPlanVersionsPaginated(
                request: ListBackupPlanVersionsRequest
            ): IO[
              AwsError,
              zio.aws.backup.model.ListBackupPlanVersionsResponse.ReadOnly
            ] = proxy(ListBackupPlanVersionsPaginated, request)
            def startRestoreJob(request: StartRestoreJobRequest): IO[
              AwsError,
              zio.aws.backup.model.StartRestoreJobResponse.ReadOnly
            ] = proxy(StartRestoreJob, request)
            def listReportPlans(request: ListReportPlansRequest): ZStream[
              Any,
              AwsError,
              zio.aws.backup.model.ReportPlan.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListReportPlans, request)
                }
                .getOrThrowFiberFailure()
            }
            def listReportPlansPaginated(request: ListReportPlansRequest): IO[
              AwsError,
              zio.aws.backup.model.ListReportPlansResponse.ReadOnly
            ] = proxy(ListReportPlansPaginated, request)
            def describeBackupJob(request: DescribeBackupJobRequest): IO[
              AwsError,
              zio.aws.backup.model.DescribeBackupJobResponse.ReadOnly
            ] = proxy(DescribeBackupJob, request)
            def getBackupPlan(request: GetBackupPlanRequest): IO[
              AwsError,
              zio.aws.backup.model.GetBackupPlanResponse.ReadOnly
            ] = proxy(GetBackupPlan, request)
            def describeGlobalSettings(
                request: DescribeGlobalSettingsRequest
            ): IO[
              AwsError,
              zio.aws.backup.model.DescribeGlobalSettingsResponse.ReadOnly
            ] = proxy(DescribeGlobalSettings, request)
            def describeCopyJob(request: DescribeCopyJobRequest): IO[
              AwsError,
              zio.aws.backup.model.DescribeCopyJobResponse.ReadOnly
            ] = proxy(DescribeCopyJob, request)
            def deleteBackupVaultLockConfiguration(
                request: DeleteBackupVaultLockConfigurationRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteBackupVaultLockConfiguration, request)
            def listBackupPlans(request: ListBackupPlansRequest): ZStream[
              Any,
              AwsError,
              zio.aws.backup.model.BackupPlansListMember.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListBackupPlans, request)
                }
                .getOrThrowFiberFailure()
            }
            def listBackupPlansPaginated(request: ListBackupPlansRequest): IO[
              AwsError,
              zio.aws.backup.model.ListBackupPlansResponse.ReadOnly
            ] = proxy(ListBackupPlansPaginated, request)
            def getSupportedResourceTypes(): IO[
              AwsError,
              zio.aws.backup.model.GetSupportedResourceTypesResponse.ReadOnly
            ] = proxy(GetSupportedResourceTypes)
            def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
              proxy(TagResource, request)
            def createReportPlan(request: CreateReportPlanRequest): IO[
              AwsError,
              zio.aws.backup.model.CreateReportPlanResponse.ReadOnly
            ] = proxy(CreateReportPlan, request)
            def describeRecoveryPoint(
                request: DescribeRecoveryPointRequest
            ): IO[
              AwsError,
              zio.aws.backup.model.DescribeRecoveryPointResponse.ReadOnly
            ] = proxy(DescribeRecoveryPoint, request)
            def createBackupSelection(
                request: CreateBackupSelectionRequest
            ): IO[AwsError, ReadOnly] = proxy(CreateBackupSelection, request)
            def stopBackupJob(
                request: StopBackupJobRequest
            ): IO[AwsError, Unit] = proxy(StopBackupJob, request)
            def listReportJobs(
                request: ListReportJobsRequest
            ): ZStream[Any, AwsError, zio.aws.backup.model.ReportJob.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListReportJobs, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listReportJobsPaginated(request: ListReportJobsRequest): IO[
              AwsError,
              zio.aws.backup.model.ListReportJobsResponse.ReadOnly
            ] = proxy(ListReportJobsPaginated, request)
            def startBackupJob(request: StartBackupJobRequest): IO[
              AwsError,
              zio.aws.backup.model.StartBackupJobResponse.ReadOnly
            ] = proxy(StartBackupJob, request)
            def putBackupVaultNotifications(
                request: PutBackupVaultNotificationsRequest
            ): IO[AwsError, Unit] = proxy(PutBackupVaultNotifications, request)
            def describeProtectedResource(
                request: DescribeProtectedResourceRequest
            ): IO[
              AwsError,
              zio.aws.backup.model.DescribeProtectedResourceResponse.ReadOnly
            ] = proxy(DescribeProtectedResource, request)
            def getBackupPlanFromTemplate(
                request: GetBackupPlanFromTemplateRequest
            ): IO[
              AwsError,
              zio.aws.backup.model.GetBackupPlanFromTemplateResponse.ReadOnly
            ] = proxy(GetBackupPlanFromTemplate, request)
            def updateBackupPlan(request: UpdateBackupPlanRequest): IO[
              AwsError,
              zio.aws.backup.model.UpdateBackupPlanResponse.ReadOnly
            ] = proxy(UpdateBackupPlan, request)
            def updateGlobalSettings(
                request: UpdateGlobalSettingsRequest
            ): IO[AwsError, Unit] = proxy(UpdateGlobalSettings, request)
            def deleteBackupVaultNotifications(
                request: DeleteBackupVaultNotificationsRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteBackupVaultNotifications, request)
            def getBackupPlanFromJSON(
                request: GetBackupPlanFromJsonRequest
            ): IO[
              AwsError,
              zio.aws.backup.model.GetBackupPlanFromJsonResponse.ReadOnly
            ] = proxy(GetBackupPlanFromJSON, request)
            def updateFramework(request: UpdateFrameworkRequest): IO[
              AwsError,
              zio.aws.backup.model.UpdateFrameworkResponse.ReadOnly
            ] = proxy(UpdateFramework, request)
            def describeReportJob(request: DescribeReportJobRequest): IO[
              AwsError,
              zio.aws.backup.model.DescribeReportJobResponse.ReadOnly
            ] = proxy(DescribeReportJob, request)
          }
        }
      }
    }
  }
}
