package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.BackupVaultName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutBackupVaultLockConfigurationRequest(
    backupVaultName: BackupVaultName,
    minRetentionDays: Optional[Long] = Optional.Absent,
    maxRetentionDays: Optional[Long] = Optional.Absent,
    changeableForDays: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.PutBackupVaultLockConfigurationRequest = {
    import PutBackupVaultLockConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.PutBackupVaultLockConfigurationRequest
      .builder()
      .backupVaultName(
        BackupVaultName.unwrap(backupVaultName): java.lang.String
      )
      .optionallyWith(minRetentionDays.map(value => value: java.lang.Long))(
        _.minRetentionDays
      )
      .optionallyWith(maxRetentionDays.map(value => value: java.lang.Long))(
        _.maxRetentionDays
      )
      .optionallyWith(changeableForDays.map(value => value: java.lang.Long))(
        _.changeableForDays
      )
      .build()
  }
  def asReadOnly
      : zio.aws.backup.model.PutBackupVaultLockConfigurationRequest.ReadOnly =
    zio.aws.backup.model.PutBackupVaultLockConfigurationRequest
      .wrap(buildAwsValue())
}
object PutBackupVaultLockConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.PutBackupVaultLockConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.backup.model.PutBackupVaultLockConfigurationRequest =
      zio.aws.backup.model.PutBackupVaultLockConfigurationRequest(
        backupVaultName,
        minRetentionDays.map(value => value),
        maxRetentionDays.map(value => value),
        changeableForDays.map(value => value)
      )
    def backupVaultName: BackupVaultName
    def minRetentionDays: Optional[Long]
    def maxRetentionDays: Optional[Long]
    def changeableForDays: Optional[Long]
    def getBackupVaultName: ZIO[Any, Nothing, BackupVaultName] =
      ZIO.succeed(backupVaultName)
    def getMinRetentionDays: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("minRetentionDays", minRetentionDays)
    def getMaxRetentionDays: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("maxRetentionDays", maxRetentionDays)
    def getChangeableForDays: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("changeableForDays", changeableForDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.PutBackupVaultLockConfigurationRequest
  ) extends zio.aws.backup.model.PutBackupVaultLockConfigurationRequest.ReadOnly {
    override val backupVaultName: BackupVaultName =
      zio.aws.backup.model.primitives.BackupVaultName(impl.backupVaultName())
    override val minRetentionDays: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.minRetentionDays())
      .map(value => value: Long)
    override val maxRetentionDays: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRetentionDays())
      .map(value => value: Long)
    override val changeableForDays: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.changeableForDays())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.PutBackupVaultLockConfigurationRequest
  ): zio.aws.backup.model.PutBackupVaultLockConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
