package zio.aws.backup.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.backup.model.primitives.ARN
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RecoveryPointMember(
    recoveryPointArn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.backup.model.RecoveryPointMember = {
    import RecoveryPointMember.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.backup.model.RecoveryPointMember
      .builder()
      .optionallyWith(
        recoveryPointArn.map(value => ARN.unwrap(value): java.lang.String)
      )(_.recoveryPointArn)
      .build()
  }
  def asReadOnly: zio.aws.backup.model.RecoveryPointMember.ReadOnly =
    zio.aws.backup.model.RecoveryPointMember.wrap(buildAwsValue())
}
object RecoveryPointMember {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.backup.model.RecoveryPointMember
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.backup.model.RecoveryPointMember =
      zio.aws.backup.model
        .RecoveryPointMember(recoveryPointArn.map(value => value))
    def recoveryPointArn: Optional[ARN]
    def getRecoveryPointArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField("recoveryPointArn", recoveryPointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.backup.model.RecoveryPointMember
  ) extends zio.aws.backup.model.RecoveryPointMember.ReadOnly {
    override val recoveryPointArn: Optional[ARN] = zio.aws.core.internal
      .optionalFromNullable(impl.recoveryPointArn())
      .map(value => zio.aws.backup.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.backup.model.RecoveryPointMember
  ): zio.aws.backup.model.RecoveryPointMember.ReadOnly = new Wrapper(impl)
}
